{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, 
             EmptyDataDecls, ExistentialQuantification, ScopedTypeVariables #-}

-- module HROOT.Class.Interface where

module HROOT.Graf.TTUBE.Interface where


import Data.Word
import Foreign.C
import Foreign.Ptr
import Foreign.ForeignPtr
import FFICXX.Runtime.Cast

import HROOT.Graf.TTUBE.RawType

import HROOT.Graf.TShape.Interface
---- ============ ----



class (ITShape a) => ITTUBE a where

instance Existable TTUBE where
  data Exist TTUBE = forall a. (FPtr a, ITTUBE a) => ETTUBE a

upcastTTUBE :: (FPtr a, ITTUBE a) => a -> TTUBE
upcastTTUBE h = let fh = get_fptr h
                    fh2 :: ForeignPtr RawTTUBE = castForeignPtr fh
                in cast_fptr_to_obj fh2

downcastTTUBE :: (FPtr a, ITTUBE a) => TTUBE -> a 
downcastTTUBE h = let fh = get_fptr h
                      fh2 = castForeignPtr fh
                  in cast_fptr_to_obj fh2
