{-# LANGUAGE BangPatterns #-}
{-# LANGUAGE TypeApplications #-}
{-# OPTIONS_GHC -O0 #-} -- optimizations break this benchmark, sadly
module Main (main) where
import Criterion (bench, whnf)
import Criterion.Main (defaultMain)
import Numeric.Natural (Natural)
import Data.Infinitree (Infinitree)
import qualified Data.Functor.Rep as Representable

fibIterative :: Natural -> Natural
fibIterative n = go 1 1 n
  where
    go !a _ 0   = a
    go !a !b !i = go b (a+b) (pred i)

large :: Natural
large = 8310

infinitree :: Natural -> Natural
infinitree n = 
  let 
    tree = Representable.tabulate @Infinitree go
    go 0 = 1
    go 1 = 1
    go i = Representable.index tree (i - 1) + Representable.index tree (i - 2)

  in Representable.index tree n

main :: IO ()
main = defaultMain
  [ bench "iterative"  $ whnf fibIterative large
  , bench "infinitree" $ whnf infinitree large
  ]
