{-# LANGUAGE TypeApplications #-}
-- | 
-- Copyright: (c) VegOwOtenks
-- License: AGPL3
--
-- This is the example usage module, you're meant to look at the source code, feel free to click the `Source` link below
module Data.Infinitree.Examples
(fib)
where

import Data.Infinitree ( Infinitree )

import qualified Data.Functor.Rep as Representable
import Numeric.Natural (Natural)

-- | This defines a convenience function
-- users wouldn't have to call Representable.index fibonacci themselves
-- This example is written to have you look at the source code for example usage.

fib :: Natural -> Integer
fib = Representable.index fibonacci

-- | a tree of all fibonacci numbers
--
-- while this enables memoization it also adds a O(log n) overhead to every lookup

fibonacci :: Infinitree Integer
fibonacci = Representable.tabulate @Infinitree go
  -- `Representable.tabulate @Infinitree go` is equivalent to `fmap go nats` but more efficient because it doesn't maintain two trees
  where
    -- go is the fibonacci function, it will be called with every index
    go 0 = 0
    go 1 = 1
    -- sum the lower to fibonacci numbers from the tree
    go n = Representable.index fibonacci (n - 1) + Representable.index fibonacci (n - 2)

