module PatSyn where
import Data.Constraint

{-
pattern P1 x = (x, True)

pattern P2 x y <- x@(y, True)

--pattern P3 x <- Just x
--  where P3 x = Just (abs x)
-}

-- pattern T = True

class None
instance None

mkT :: Bool
mkT = True

--unT :: Bool -> Maybe (Dict None)
unT :: Bool -> Maybe ()
unT True = Just () -- Dict
unT _ = Nothing

f1 :: Bool -> Int
f1 True = 1
f1 _ = 0

f2 :: Bool -> Int
--f2 (unT -> (Just Dict)) = 1
f2 (unT -> (Just _)) = 1
f2 _ = 0

unL :: Either a b -> Maybe a
unL (Left a) = Just a
unL _ = Nothing

f3 :: Either Int b -> Int
f3 (Left a) = a
f3 _ = 0

f4 :: Either Int b -> Int
f4 (unL -> (Just a)) = a
f4 _ = 0

main :: IO ()
main = do
  print (f1 True)
  print (f1 False)
  print (f2 mkT)
  print (f2 False)
  cprint f1
  cprint f2
  print (f3 (Left 10))
  print (f4 (Left 10))
  cprint f3
  cprint f4
  
