module Quant(main) where

{-
type Rose :: (Type -> Type) -> Type -> Type
data Rose (f :: Type -> Type) a = Branch a (f (Rose f a))

instance forall f a . (Eq a, forall b. (Eq b) => Eq (f b)) => Eq (Rose f a) where
    (Branch x1 c1) == (Branch x2 c2)  =  x1==x2 && c1==c2
--eq :: forall f a . (Eq a, forall b. (Eq b) => Eq (f b)) => (Rose f a) -> (Rose f a) -> Bool
--eq (Branch x1 c1) (Branch x2 c2)  =  x1==x2 && c1==c2

t1 :: Rose [] Int
t1 = Branch 1 [Branch 2 [], Branch 3 []]

main :: IO ()
main = do
  print $ t1 == t1
-}


type T :: (Type -> Type) -> Type -> Type
data T f a = C (f a)

eq :: forall a f .
      (Eq a, forall b. (Eq b) => Eq (f b)) => T f a -> T f a -> Bool
eq (C xxx) (C yyy) = xxx == yyy

x :: T [] Int
x = C [1]

main :: IO ()
main = print $ eq x x
