-- Copyright 2023-2025 Lennart Augustsson
-- See LICENSE file for full license.
module Mhs.Builtin(
  module Control.Monad,
  module Control.Monad.Fail,
  module Control.Monad.Fix,
  module Data.Bool,
  module Data.Char,
  module Data.Coerce,
  module Data.Data_Class,
  module Data.Enum,
  module Data.Eq,
--  module Data.Foldable,
  module Data.Fractional,
  module Data.Function,
  module Data.Functor,
  module Data.Ord,
  module Data.Num,
  module Data.Records,
  module Data.Typeable,
  module Data.Monoid.Internal,
  module Data.String,
  module Text.ParserCombinators.ReadPrec,
  module Text.Read.Internal,
  module Text.Read.Lex,
  module Text.Show,
  module Mhs.Builtin,
  ) where
--
-- These are the identifiers that can be generated by the compiler,
-- so they always have to be in scope.
-- In the compiler this module is treated specially, it is imported
-- qualified with the name B@, this way these names are always available
-- qualified, but under a name that cannot be used accidentally.
-- If the Prelude is not imported, then neither is this module.
import qualified Prelude()  -- no Prelude
import Control.Applicative(Applicative((<*>)))
import Control.Error(error)
import Control.Monad(Monad(..))
import Control.Monad.Fail(MonadFail(..))
import {-# SOURCE #-} Control.Monad.Fix(_mfix)
import Data.Bool((&&), Bool(..))
import Data.Char(Char)
import Data.Coerce(Coercible, coerce)
import Data.Data_Class(Data(..), Fixity(..), mkDataType, mkConstrTag, constrIndex)
import Data.Enum(Enum(enumFrom, enumFromThen, enumFromTo, enumFromThenTo))
import Data.Eq(Eq(..))
--import Data.Foldable(Foldable(..))
import qualified Data.Foldable
import Data.Fractional(Fractional(fromRational))
import Data.Function((.), id, flip)
import Data.Functor(Functor(..), (<$>))
import Data.Ord(Ord(..), Ordering(..))
import Data.Num(Num((+), (-), (*), fromInteger, negate))
import Data.Proxy(Proxy(..))
import Data.Monoid.Internal(Semigroup(..))
import Data.String(IsString(..))
import Data.Records(HasField(..), SetField(..), composeSet)
import Data.Traversable(Traversable(..))
import {-# SOURCE #-} Data.Typeable(Typeable(..), _mkTyCon, gcast1, gcast2)
import Text.ParserCombinators.ReadPrec((+++), pfail, prec, step, reset)
import Text.Read.Internal(Read(..), readListDefault, readListPrecDefault, parens, expectP, readField)
import Text.Read.Lex(Lexeme(..))
import Text.Show(Show(..), showString, showParen)

-- Types to fake unboxed sums
data USum2 a0 a1 = USum2_0 a0 | USum2_1 a1
data USum3 a0 a1 a2 = USum3_0 a0 | USum3_1 a1 | USum3_2 a2
data USum4 a0 a1 a2 a3 = USum4_0 a0 | USum4_1 a1 | USum4_2 a2 | USum4_3 a3

-- Types to fake unboxed tuples
data UProd0 = UProd0
newtype UProd1 a0 = UProd1 a0
data UProd2 a0 a1 = UProd2 a0 a1
data UProd3 a0 a1 a2 = UProd3 a0 a1 a2
data UProd4 a0 a1 a2 a3 = UProd4 a0 a1 a2 a3

-- Functions used for deriving Foldable
ffoldr :: Data.Foldable.Foldable f => (a -> b -> b) -> f a -> b -> b
ffoldr f = flip (Data.Foldable.foldr f)

flipConst :: a -> b -> b
flipConst _ b = b

foldTuple2 :: (a1 -> b -> b) -> (a2 -> b -> b) -> (a1, a2) -> b -> b
foldTuple2 f1 f2 (a1, a2) z = f1 a1 (f2 a2 z)

foldTuple3 :: (a1 -> b -> b) -> (a2 -> b -> b) -> (a3 -> b -> b) -> (a1, a2, a3) -> b -> b
foldTuple3 f1 f2 f3 (a1, a2, a3) z = f1 a1 (f2 a2 (f3 a3 z))

foldTuple4 :: (a1 -> b -> b) -> (a2 -> b -> b) -> (a3 -> b -> b) -> (a4 -> b -> b) -> (a1, a2, a3, a4) -> b -> b
foldTuple4 f1 f2 f3 f4 (a1, a2, a3, a4) z = f1 a1 (f2 a2 (f3 a3 (f4 a4 z)))

-- Functions used for deriving Functor
fmapTuple2 :: (a1 -> b1) -> (a2 -> b2) -> (a1, a2) -> (b1, b2)
fmapTuple2 f1 f2 (a1, a2) = (f1 a1, f2 a2)

fmapTuple3 :: (a1 -> b1) -> (a2 -> b2) -> (a3 -> b3) -> (a1, a2, a3) -> (b1, b2, b3)
fmapTuple3 f1 f2 f3 (a1, a2, a3) = (f1 a1, f2 a2, f3 a3)

fmapTuple4 :: (a1 -> b1) -> (a2 -> b2) -> (a3 -> b3) -> (a4 -> b4) -> (a1, a2, a3, a4) -> (b1, b2, b3, b4)
fmapTuple4 f1 f2 f3 f4 (a1, a2, a3, a4) = (f1 a1, f2 a2, f3 a3, f4 a4)

-- Functions used for deriving Traversable
travTuple2 :: Applicative f =>
              (a1 -> f b1) -> (a2 -> f b2) -> (a1, a2) -> f (b1, b2)
travTuple2 f1 f2 (a1, a2) = (,) <$> f1 a1 <*> f2 a2

travTuple3 :: Applicative f =>
              (a1 -> f b1) -> (a2 -> f b2) -> (a3 -> f b3) -> (a1, a2, a3) -> f (b1, b2, b3)
travTuple3 f1 f2 f3 (a1, a2, a3) = (,,) <$> f1 a1 <*> f2 a2 <*> f3 a3

travTuple4 :: Applicative f =>
              (a1 -> f b1) -> (a2 -> f b2) -> (a3 -> f b3) -> (a4 -> f b4) -> (a1, a2, a3, a4) -> f (b1, b2, b3, b4)
travTuple4 f1 f2 f3 f4 (a1, a2, a3, a4) = (,,,) <$> f1 a1 <*> f2 a2 <*> f3 a3 <*> f4 a4
