module Foreign.C.String(
  CChar, CString,
  newCAString, newCAStringLen,
  peekCAString, peekCAStringLen,
  withCAString,
  ) where
import Primitives
import Data.Char_Type
import Foreign.Marshal.Alloc

type CChar = Char
type CString = Ptr CChar
type CStringLen = (Ptr CChar, Int)

newCAString :: String -> IO CString
newCAString s = primNewCAStringLen s `primBind` \ (s, _) -> primReturn s

newCAStringLen :: String -> IO CStringLen
newCAStringLen = primNewCAStringLen

withCAString :: forall a . String -> (CString -> IO a) -> IO a
withCAString s io =
  newCAString s `primBind` \ cs ->
  io cs `primBind` \ a ->
  free cs `primThen`
  primReturn a

peekCAString :: CString -> IO String
peekCAString = primPeekCAString

peekCAStringLen :: CStringLen -> IO String
peekCAStringLen (p, i) = primPeekCAStringLen p i
