{-# LANGUAGE TemplateHaskell #-}

module MonadLab.Identity (
   identityMonad
 ) where

import Prelude hiding (Monad)
import Language.Haskell.TH
import MonadLab.CommonTypes

identityMonad :: Monad
identityMonad = (identityTypeCon , identityReturn , identityBind, [], identityBaseLift)

identityTypeCon :: MonadTypeCon
identityTypeCon = \t -> t 

identityReturn :: ReturnExpQ
identityReturn = [| \v -> v |]

identityBind :: BindExpQ
identityBind = [| \m -> \f -> f m |]

identityBaseLift :: LiftExpQ
identityBaseLift = [| id |]
