{-# LANGUAGE TemplateHaskell #-}

module MonadLab.Io (
   ioMonad
 ) where

import Prelude hiding (Monad)
import Language.Haskell.TH
import MonadLab.CommonTypes

ioMonad :: Monad
ioMonad = (ioTypeCon , ioReturn , ioBind, [(Io, [liftIO])], ioBaseLift)

ioTypeCon :: MonadTypeCon
ioTypeCon = \t -> appT (conT ''IO) t 

ioReturn :: ReturnExpQ
ioReturn = [| return |]

ioBind :: BindExpQ
ioBind = [| (>>=) |]

liftIO :: NonProperMorphismExpQ
liftIO = [| id |]

ioBaseLift :: LiftExpQ
ioBaseLift = [| id |]
