module Main where
import System.Environment (getArgs, withArgs)

import Test.MuCheck (mucheck)
import Test.MuCheck.TestAdapter.QuickCheck
import Test.MuCheck.TestAdapter
import Test.MuCheck.Utils.Print

main :: IO ()
main = do
  val <- getArgs
  case val of
    ("-h" : _ ) -> help
    (fn : file : modulename : args) -> withArgs [] $ mucheck tsFn fn file modulename args
    _ -> error "Need function file modulename [args]\n\tUse -h to get help"
  where tsFn :: [MutantFilename] -> [InterpreterOutput QuickCheckSummary] -> Summary
        tsFn = testSummary


help :: IO ()
help = putStrLn $ "mucheck function file modulename [args]\n" ++ showAS ["E.g:",
       " mucheck-quickcheck qsort Examples/QuickCheckTest.hs Examples.QuickCheckTest 'quickCheckResult idEmpProp' 'quickCheckResult revProp' 'quickCheckResult modelProp'",""]
