{-# LANGUAGE StandaloneDeriving, DeriveDataTypeable, TypeSynonymInstances #-}
-- | Module for using quickcheck properties
module Test.MuCheck.TestAdapter.QuickCheck where
import qualified Test.QuickCheck.Test as Qc
import Test.MuCheck.TestAdapter
import Test.MuCheck.Utils.Print (showA, showAS)

import Data.Typeable
import Data.List((\\))
import Data.Either (partitionEithers)

deriving instance Typeable Qc.Result
type QuickCheckSummary = Qc.Result

-- | Summarizable instance of `QuickCheck.Result`
instance Summarizable QuickCheckSummary where
  testSummary mutantFiles results = Summary logMsg
    where (errorCases, executedCases) = partitionEithers results
          [successCases, failureCases, gaveUpCases] = map (\c -> filter (c . snd) executedCases) [isSuccess, isFailure, isOther]
          errorFiles = mutantFiles \\ map fst executedCases
          logMsg = showAS ["Details:",
                           "Loading error files:", showA errorFiles,
                           "Loading error messages:", showA errorCases,
                           "Successes:", showA successCases,
                           "Failure:", showA failureCases,
                           "Gaveups:", showA gaveUpCases]
  isSuccess = Qc.isSuccess
  isFailure Qc.Failure{} = True
  isFailure _            = False
  isOther   Qc.GaveUp{}  = True
  isOther   _            = False
