## UNRELEASED

## QuickCheck 2.18.0.0 (released 2026-02-26)
* BREAKING: Added a number of `CoArbitrary` and `Function` instances for types in `base`
* Improve implementation of `shrinkIntegral` (thanks tom93)
* Improve implementation of `Arbitrary NonEmptyList` (thanks konsumlamm)
* Convert changelog to markdown (thanks Artem)
* Deprecate `withMaxSuccess` in favour of the renamed `withNumTests`
* `Test.QuickCheck.Function` marked as `Trustworthy` not `Safe`
* Fix bug in heap example

## QuickCheck 2.17.1.0 (released 2025-10-13)
* Fix random-1.2 support (thanks bodigrim)
* Update docs (thanks effectfully)

## QuickCheck 2.17.0.0 (released 2025-10-07)
* Lower the memory use of `arbitrary` for `Double` and `Float` (thanks
ChickenProp)
* BREAKING: Remove `Gen.Class`
* BREAKING: Add `Arbitrary` instances for most of the types in `base`
* Add microHS support (thanks Lennart)

## QuickCheck 2.16.0.0 (released 2025-06-17)
* Add a `Safe` declaration to `Test.QuickCheck.Monoids`
* Fix `Test.QuickCheck.Features` to not depend on the internal testing loop
* Add `withProgress` to install common callbacks for downstream tools
* Relax bounds on `random` dependency (thanks to LaurentRDC and
Andreas Abel)
* Fix some haddock issues (thanks to pgujjula)
* Use `displayException` instead of `show` (thanks Edsko)
* Added helper monoids `Every` and `Some` for predicates (thanks
Marcin)

## QuickCheck 2.15 (released 2024-04-22)
* BREAKING: properties without quantification are no longer implicitly
  wrapped in once
* Add witness property modifier and witnesses field in result on
compilers that support Typeable to allow conveniently exposing
counterexamples
* Add assertException, assertExceptionIO, assertDeepException, and
assertDeepExceptionIO (thanks to Alexey Kuleshevich)
* Add withMaxSize, withMaxShrinks, and withMaxDiscardRatio combinators
* Add recheck
* Add HasCallStack to partial top-level functions
* Updated some documentation
* Fix overflow bug when calculating discard ratio
* Fix error printing bug when shrinks are discarded
* Fix withMaxSuccess not working when checkCoverage is turned on
* Fix a bug whereby an unfortunately timed discard could unduly fail a
property running with checkCoverage
* Fix Arbitrary intance for Map breaking invariants from
Data.Map.Strict (thanks to Neil Mayhew)
* Fix non-covered classes not showing up in output as 0% covered
* Fix Negative's Arbitrary instance discarding an unnecessary number
of generated values.
* Fix promote doing an unnecessary seed split
* Fix a bug whereby maxSuccess and discardRatio would interact poorly
to produce too few size increases.
* Fix a couple of underflow bugs in generators for Small Natural and
Ratio Natural
* Fix a bug whereby the internal DISCARDED exception would show up
user-side in sample

## QuickCheck 2.14.3 (released 2023-05-31)
* Add shrinkBoundedEnum (thanks to Jonathan Knowles)
* Add discardAfter for discarding tests on timeout (thanks to Justus Sagemüller)
* Add assertWith for monadic testing (thanks to KtorZ)
* Add functionElements to Test.QuickCheck.Function (thanks to Oleg Grenrus)
* Add Arbitrary instance for Newline (thanks to Daniel Bramucci)
* Improve Arbitrary instances for Float and Double (thanks to Oleg Grenrus)
* Improve arbitrarySizedFractional (thanks to Bodigrim)
* Fix shrinkRealFrac and shrinkDecimal, which were broken
* Speed up printing of progress messages (thanks to Bodigrim)
* Add COMPLETE pragmas for Fn and family (thanks to ilkecan)
* Make templateHaskell flag manual (thanks to Oleg Grenrus)

## QuickCheck 2.14.2 (released 2020-11-14)
* Add Arbitrary instances for Tree (thanks to Oleg Grenrus)
* GHC 9.0 compatibility (thanks to Vilem-Benjamin Liepelt)

## QuickCheck 2.14.1 (released 2020-07-05)
* Compatibility with random >= 1.2.

## QuickCheck 2.14 (released 2020-03-28)
* QuickCheck is now much faster at generating test data!
  As a result, many properties can now be tested a lot faster;
  the examples distributed with QuickCheck run about twice as
  fast as before, for example. Of course, your mileage may vary.

  The reason for this is that there are now specialised versions
  of the 'choose' combinator for various types. These are:
  chooseInt, chooseInteger, chooseBoundedIntegral, and chooseEnum.
  These combinators are identical to 'choose' but much faster.
  All QuickCheck combinators, with the exception of 'choose'
  itself, use the new combinators behind the scenes.

  You should see a speedup without doing anything, but to get a
  further speedup, consider replacing any uses of 'choose' in your
  own generators with the new combinators.

  We are hoping that future releases of the 'random' library may
  speed up 'choose', in which case these combinators may no longer
  be needed.

  Thanks to Oleg Grenrus for suggesting to bypass 'choose' for
  random number generation, and providing the appropriate
  primitive in his 'splitmix' random number library.

* Smaller changes and bugfixes:
- RecursivelyShrink and GSubterms are exported from
  Test.QuickCheck.Test (thanks to Tom Mortiboy).
- Don't generate invalid unicode characters
  (thanks to Boris Stepanov).
- When a call to 'within' fails, include the duration of the
  timeout in the failure report (thanks to William Rusnack).
- In Gen, avoid splitting the seed in the implementation of
  >>, *> and <* (thanks to David Feuer).
- Fix a couple of bugs with shrinking of floating-point
  numbers.
- Export functionMapWith, functionEitherWith and
  functionPairWith from Test.QuickCheck.Function
  (thanks to Oleg Grenrus).
- Remove redundant RealFloat constraint from
  Arbitrary/CoArbitrary instances for Complex
  (thanks to Bodigrim).

## QuickCheck 2.13.2 (released 2019-06-30)
* Compatibility with GHC 8.8 (thanks to Bodigrim)
* Improve error message when 'frequency' is used with only zero weights
* Add 'functionVoid' combinator (thanks to Oleg Grenrus)
* Tighten bounds for random package (thanks to Oleg Grenrus)

## QuickCheck 2.13.1 (released 2019-03-29)
* A couple of bug fixes

## QuickCheck 2.13 (released 2019-03-26)
* Properties with multiple arguments now shrink better.
  Previously, the first argument was shrunk, then the second, and
  so on. Now, the arguments are shrunk as a whole, so shrink steps
  for different arguments can be interleaved.

* New features:
    - New modifiers Negative and NonPositive
    - A Testable instance for Maybe prop (where Nothing means 'discard
      the test case')
* Dependencies on C code removed:
    - Use splitmix instead of tf-random for random number generation
    - Remove dependency on 'erf' package
* Small changes:
    - Say 'Falsified' instead of 'Falsifiable' when a property fails
* Compatibility improvements:
    - Explicitly derive instance Typeable Args
    - Lower bound on deepseq
    - A script for building Hugs packages

## QuickCheck 2.12.6 (released 2018-10-02)
* Make arbitrarySizedBoundedIntegral handle huge sizes correctly.
* Add changelog for QuickCheck 2.12.5 :)

## QuickCheck 2.12.5 (released 2018-09-30)
* Export isSuccess from Test.QuickCheck.
* Export CoArbitrary even when generics are disabled (bugfix).
* Fix bug in shrinkDecimal.
* Include Test.QuickCheck.Gen in exposed modules for Haddock.

## QuickCheck 2.12.3, 2.12.4 (released 2018-09-12)
* Shrinking for Float and Decimal now works by reducing the number
  of digits in the number. The new function shrinkDecimal
  implements this shrinking behaviour.
* Shrinking for Rational now tries to make the numerator and
  denominator of the number smaller. Previously it tried to reduce
  the magnitude of the number.

## QuickCheck 2.12.2 (released 2018-09-10)
* Fix infinite shrinking loop for fractional types.
* Add SortedList modifier.

## QuickCheck 2.12.1 (released 2018-09-06)
* Fix bug in 'classify'.

## QuickCheck 2.12 (released 2018-09-03)
* Silently breaking changes!
    - The Arbitrary instance for Word now generates only small
      values, the same as Int
    - cover no longer causes a property failure if coverage is
      insufficient. It just prints a warning. (But see next item!)

* Overhaul of label/cover family of combinators:
    - New property combinator checkCoverage, which checks coverage
      requirements in a statistically sound way, and *does* fail if
      they are not met.
    - Order of arguments to cover swapped, to make it easier to
      switch between classify and cover
    - New combinators tabulate and coverTable, for reporting test
      case distribution more flexibly than label.
    - When label is called multiple times in a property, each call
      produces a separate table of frequencies.

* New functions:
    - (=/=): like (/=), but prints a counterexample
      (thanks to tom-bop)
    - forAllShow/forAllShrinkShow: quantification using an
      explicit show function (thanks to Stevan Andjelkovic)
    - forAllBlind/forAllShrinkBlind: quantification without
      printing anything
    - verboseShrinking: see how a counterexample is shrunk
    - labelledExamples: given a property which uses label,
      generate an example test case for each label
    - idempotentIOProperty: a variant of ioProperty which shrinks
      better but only works for idempotent I/O actions

* Other improvements:
    - MonadFix Gen instance (thanks to Jon Fowler)
    - Rational numbers shrink using continued fractions
      (thanks to Justus Sagemüller)
    - Function instances for Const, Identity, and the types in
      Data.Monoid; instance Functor Fun (thanks to Erik Schnetter
      and Xia Li-yao)
    - More of Test.QuickCheck.Function is exported from
      Test.QuickCheck
    - Semantics of .||. changed to improve short-circuiting:
      if the left argument's precondition is false, the right
      argument is not evaluated and the whole disjunction is
      considered to have a false precondition
    - Bug fix: suchThatMaybe always increased size to at least 1

* Miscellaneous API changes:
    - Result type has changed a bit:
        - InsufficientCovered constructor is gone
        - Type of labels has changed
        - New fields classes, tables

## QuickCheck 2.11.1 - 2.11.3 (released 2018-01-12)
* Cosmetic fixes.

## QuickCheck 2.11 (released 2018-01-12)
* New features:
    - InfiniteList modifier generates infinite lists and shows
      only the relevant part.
    - applyArbitrary2/3/4 for applying a function to random
      arguments.
    - Template Haskell function allProperties returns all
      properties in a module.

* Applicative Gen instances do less splitting.
* Property now has a Typeable instance.
* (===) now prints correct output when the property is true.
* Test.QuickCheck now exports Fun constructor.
* verboseCheck output is now slightly less confusing.

## QuickCheck 2.10.1 (released 2017-10-06)
* Arbitrary instances for Foreign.C.Types are available in more
  GHC versions.
* Fixed a bug where withMaxSuccess didn't adjust the allowed
  number of discarded tests.
* Remove quadratic behaviour in terminal output.

## QuickCheck 2.10 (released 2017-06-15)
* New combinators:
    - withMaxSuccess sets the maximum number of test cases for a property.
    - shrinkMap/shrinkMapBy are helpers for defining shrink functions.
    - total checks that a value is non-crashing.
    - suchThatMap is similar to 'suchThat'
      but takes a Maybe-returning function instead of a predicate.
    - getSize returns the current test case size.

* Random strings and characters now include Unicode characters by
  default. To generate only ASCII characters, use the new
  ASCIIString modifier or arbitraryASCIIChar generator.
  The following modifiers and generators also control the
  kind of strings generated: UnicodeString, PrintableString,
  arbitraryUnicodeChar, arbitraryPrintableChar.

* QuickCheck no longer catches asynchronous exceptions, which
  means that pressing ctrl-C will now cancel testing without
  printing a counterexample. If you are debugging an infinite loop,
  please use the 'within' combinator or 'verboseCheck' instead.
  ('within' is better as it allows the counterexample to be
  shrunk.)

* Much of Test.QuickCheck.Function (showable random functions)
  is now exported from Test.QuickCheck.
    - Test.QuickCheck.Function now defines functions and
      pattern synonyms which simplify testing functions of
      more than one argument: apply2, apply3, Fn2, Fn3.

* New typeclasses Arbitrary1 and Arbitrary2 which lift Arbitrary
  to unary/binary type constructors, like in Data.Functor.Classes.

* Some Arbitrary instances have been removed: NonEmpty, Natural.
  This is because they resulted in a lot of extra dependencies.
  You can now find them in the quickcheck-instances package.
  Alternatively, use the NonEmptyList and NonNegative modifiers.

* New Arbitrary instances for the following types: Proxy, ExitCode,
  WrappedMonad, WrappedArrow, QCGen, and the types in
  Foreign.C.Types and Data.Functor.{Product,Compose}.
  Also a Function instance for Word.

* The functions in Test.QuickCheck.Monadic which take an argument
  of type PropertyM m a now expect that 'a' to be Testable, and test it.
  To reduce breakage from this, () is now an instance of Testable which
  always succeeds.
    - PropertyM now has a MonadFail instance on recent GHCs.
      Furthermore, the constraints on some instances were loosened.

* Miscellaneous API changes:
    - Result now returns the counterexample as a list of strings.
      See the "failingTestCase" field.
    - Args now has a `maxShrinks` argument, the maximum number of
      shrinks to try before giving up shrinking.
    - The 'labels' field of Result now encodes frequencies as Doubles
      rather than Ints.

* Bugfixes:
    - 'Test.QuickCheck.Function', 'Test.QuickCheck.Poly', and
      'Test.QuickCheck.Monadic' are now Safe modules.
    - Result.theException and Result.reason were taken from
      the pre-shrunk counterexample, not the shrunk one.
    - The Testable Property instance improperly used 'again'.
    - Gen.>>= is strict in the result of split, fixing a space leak.
    - within now gives a better error message on timeout

* Some more examples and links have been added to the documentation.

## QuickCheck 2.9.2 (released 2016-09-15)
* Fix a bug where some properties were only being tested once
* Make shrinking of floating-point values less aggressive
* Add function chooseAny :: Random a => Gen a

## QuickCheck 2.9.1 (released 2016-07-11)
* 'again' was only used in forAllShrink, not forAll

## QuickCheck 2.9 (released 2016-07-10)
* Arbitrary, CoArbitrary and Function instances for more types
* Generics for automatic Function instances
* A new combinator "again" which undoes the effect of "once"
* Remove "exhaustive" from Testable typeclass;
  instead, combinators which are nonexhaustive (such as forAll)
  call "again", which should be more robust

* Drop support for GHC 6.x

* Fixed bugs:
    * arbitrarySizedBoundedIntegral wasn't generating huge integers
    * verboseCheck failed with Test.QuickCheck.Function
    * label had a space leak

## QuickCheck 2.8.2 (released 2016-01-15)
* GHC 8 support
* Add Arbitrary and CoArbitrary instances for types in
  containers package
* Improve speed of shuffle combinator
* Only print to stderr if it's a terminal.
* Small changes: slightly improve documentation,
  remove redundant constraints from some functions' types,
  small improvements to Test.QuickCheck.All.

## QuickCheck 2.8.1 (released 2015-04-03)
* Fix bug where exceptions thrown printing counterexamples weren't
  being caught when terminal output was disabled
* Don't export Test.QuickCheck.Property.result

## QuickCheck 2.8 (released 2015-03-18)
* New features:
    * Support for GHC 7.10
    * Arbitrary instance for Natural
    * New generators shuffle and sublistOf
    * Support for generic coarbitrary
    * When using the cover combinator, insufficient coverage now
      causes the property to fail

* API changes:
    * Test.QuickCheck.Function: new pattern synonym Fn
    * genericShrink no longer requires Typeable
    * Result has a new constructor InsufficientCoverage
    * resize throws an error if the size is negative

* Bug fixes:
    * Fix memory leaks
    * Exceptions thrown by callbacks now cause the test to fail
    * Fixed a bug where the cover combinator wouldn't give a
      warning if coverage was 0%

## QuickCheck 2.7.3 (released 2014-03-24)
* Add annotations for Safe Haskell.

## QuickCheck 2.7.2 (released 2014-03-22)
* Fix bug in cabal file which broke cabal test

## QuickCheck 2.7.1 (released 2014-03-20)
* Fixed bug - the Small modifier didn't work on unsigned types
* Changed arbitrarySizedIntegral to have an Integral constraint
  instead of just Num

## QuickCheck 2.7 (released 2014-03-19)

* New features:
    * New genericShrink function provides generic shrinking with GHC.
    * New combinator x === y: fails if x /= y, but also prints their values
    * New function generate :: Gen a -> IO a for running a generator.
    * New combinators infiniteList and infiniteListOf for generating infinite lists.
    * Several combinators added to the main Test.QuickCheck module which
      were previously languishing in other modules. Of particular interest:
      quickCheckAll, ioProperty.
    * New combinators delay and capture which can be used (unsafely!)
      to reuse the random number seed. Useful for generating
      polymorphic (rank-2) values.
    * A new Discard data type and a Testable instance for discarding test cases.
    * All modifiers now have Functor instances and accessor functions.
    * Pressing ctrl-C during shrinking now shows the last failed
      test case, rather than the current shrinking candidate.
    * Experimental support for UHC. You will need the latest version of Cabal from git.

* Better distribution of test data:
    * The Int generator now only generates fairly small numbers.
    * The new Small and Large modifiers control the distribution of integers
      (Small generates small numbers, Large from the whole range).
    * Floating-point numbers shrink better.

* Improved random number generation:
    * QuickCheck now uses TFGen rather than StdGen on newer versions
      of GHC, because StdGen's random numbers aren't always random.
    * 'variant' now uses a prefix code. This should prevent some
      potential bananaskins with coarbitrary.

* API changes:
    * The Gen monad now uses an abstract type QCGen rather than StdGen.
    * The Result type now returns the thrown exception and number
      of failed shrink attempts.
    * Property is now a newtype rather than Gen Prop as it was before.
    * promote is moved into the new module Test.QuickCheck.Gen.Unsafe.
    * 'printTestCase' is deprecated - its new name is 'counterexample'
    * 'morallyDubiousIOProperty' is deprecated - its new name is
      'ioProperty', no moral judgement involved :)

## QuickCheck 2.6 (released 2013-03-07)

* Add convenience Function instances for up to 7-tuples
* Make stderr line buffered to reduce console I/O.
* Return a flag to say whether the test case was interrupted.

## QuickCheck 2.5 (released 2012-06-18)

* Replace maxDiscard with maxDiscardRatio
* Remove Testable () instance.
* Added a 'discard' exception that discards the current test case
* Add accessors for modifiers (where it makes sense)
* Rename 'stop' to 'abort' to avoid a name clash
* Added a 'once' combinator
* If a property is of type Bool, only run it once
* Add coarbitraryEnum to Test.QuickCheck module.
* Add 'coarbitrary' helper for Enums.
* Rejiggled the formatting code to support multi-line error messages
* Add instances for Ordering and Fixed.
* Added arbitraryBoundedEnum generator (thanks to Antoine Latter).
* Add verboseCheckAll and polyverboseCheck function for usability.
