module Global

where

import Physics
import BasicTypes
import Object

data Param = Param {
    pEps :: Double,
    pGround :: Position,
    pLeftBorderX :: Double,
    pRightBorderX :: Double,
    pUpperBorderY :: Double,
    pLowerBorderY :: Double,
    pPitchLength :: Double,
    pPitchWidth :: Double,
    pGoalWidth :: Double,

    pMaxheight :: Double,

    pGravity :: Double,
    pBouncingTime :: Double,

    pPositionFactorX :: Double,
    pPositionFactorY :: Double,

    -- Various constants that define player behaviour
    pVerticalShiftRatio :: Double,   -- defines how far a players vertically follows the ball while holding his position
    pHorizontalShiftRatio :: Double, -- dito horizontally

    pLineEnds :: Double,              -- defines at what vertical position the line will not follow the ball further

    pGameLength :: Double,             -- game length in seconds

    pRuleBaseHome :: RuleBase,
    pRuleBaseAway :: RuleBase,

    pGrid :: Grid
}
