module States

where

data BasicState =
    PBSNoBall
  | PBSInPossession
  | PBSStunned
  | PBSKickingOff
  | PBSThrowingIn
  | PBSKickingCorner
  | PBSPrepareThrowIn
 deriving (Show, Eq)

data TacticalState =
    TSNonAI
  | TSNonAIKickingOff
  | TSWaiting
  | TSCovering
  | TSPositioning
  | TSInterceptBall
  | TSHoldingPosition
  | TSMovingToThrowIn
  | TSAimingThrowIn
  | TSWaitingForKickOff
  | TSFrozen
  | TSKickingTowards
  | TSTendingGoal
  | TSGoalieWaitingForKickOff
 deriving (Show, Eq)

data BallState =
    BSFree
  | BSControlled
  | BSChallenged
  | BSOutOfPlay
  | BSControlledOOP
  | BSControlledGoalie
 deriving (Show, Eq)

data GameState =
    GSGoal
  | GSFrozen
  | GSOutOfPlay
  | GSThrowIn
  | GSKickOff
  | GSRunning
  | GSOffsitePending
  | GSQuit
 deriving (Show, Eq)
