# Revision history for RoundingFiasco

## 1.0.0.0 -- 2025-11-13

* theme: this release focuses on easy performance improvements
* breaking API changes:
  * sign functions renamed
    * `i32_arithmic_signum_f64`   to `i32_trinary_signum_f64`  (spelling, [align with WebAssembly proposal](https://github.com/WebAssembly/rounding-mode-control/commit/8de95b025d80ded9a43542c1cada4946efc31ff5#diff-269243cae603c159b27753e6cdb89fe9f654f9b9e3ac44ee713abe05ef1a5e90R42))
    * `i32_arithmic_signum_f64#`  to `i32_trinary_signum_f64#` (spelling, [align with WebAssembly proposal](https://github.com/WebAssembly/rounding-mode-control/commit/8de95b025d80ded9a43542c1cada4946efc31ff5#diff-269243cae603c159b27753e6cdb89fe9f654f9b9e3ac44ee713abe05ef1a5e90R42))
    * `i32_arithmic_signum_f32`   to `i32_trinary_signum_f32`  (spelling, [align with WebAssembly proposal](https://github.com/WebAssembly/rounding-mode-control/commit/8de95b025d80ded9a43542c1cada4946efc31ff5#diff-269243cae603c159b27753e6cdb89fe9f654f9b9e3ac44ee713abe05ef1a5e90R42))
    * `i32_arithmic_signum_f32#`  to `i32_trinary_signum_f32#` (spelling, [align with WebAssembly proposal](https://github.com/WebAssembly/rounding-mode-control/commit/8de95b025d80ded9a43542c1cada4946efc31ff5#diff-269243cae603c159b27753e6cdb89fe9f654f9b9e3ac44ee713abe05ef1a5e90R42))
    * `i32_sign_bit_f64`          to `i32_binary_signum_f64`   (align with the trinary_signum naming)
    * `i32_sign_bit_f64#`         to `i32_binary_signum_f64#`  (align with the trinary_signum naming)
    * `i32_sign_bit_f32`          to `i32_binary_signum_f32`   (align with the trinary_signum naming)
    * `i32_sign_bit_f32#`         to `i32_binary_signum_f32#`  (align with the trinary_signum naming)
  * `*` operators renamed
    * `f32_multiplicate_ceil`     to `f32_multiply_ceil`       (vocabulary)
    * `f64_multiplicate_ceil`     to `f64_multiply_ceil`       (vocabulary)
    * `f32_multiplicate_floor`    to `f32_multiply_floor`      (vocabulary)
    * `f64_multiplicate_floor`    to `f64_multiply_floor`      (vocabulary)
    * `f32_multiplicate_truncate` to `f32_multiply_truncate`   (vocabulary)
    * `f64_multiplicate_truncate` to `f64_multiply_truncate`   (vocabulary)
* minimum required GHC version:
  * bump to `9.10.3`
    * remove the deprecation warnings of usage of: `stgDoubleToWord64`, `stgFloatToWord32`, `stgWord64ToDouble`, and `castWord32ToFloat#`
    * while avoiding preprocessor macros that would conflict with a possible future Safe Haskell adoption
* performance:
  * remove superfluous sanitizing check in `f32_predecessorIEEE#`
  * manually inline low-level word literals
  * aggressive inlining throughout the codebase
    * performance improvement seen by more than 10%
  * replace debug error messages for initial development with `undefined` so that they do not increase the binaries with strings that are never supposed to be used
  * the reason for the major `A`-version bump (see [Package Versioning Policy (PVP)](https://pvp.haskell.org/)) is to indicate that every performance improvement can have unintended effects on user usecases especially for performance critical numerical code
* testing:
  * add promotion and demotion tests for NaN handling
  * add more thorough test cases for `successorIEEE` and `predecessorIEEE` regarding negative zero
* fix typos and add more documentation
* forward compatibility:
  * explicitly import from `GHC.Exts`, `GHC.Float`, `GHC.Int`, and `Data.Word` instead of implicitly

## 0.1.0.0 -- 2024-04-08

* theme: this release focuses on initial software implementation and its correctness
* floats: single, double
* rounding variants: ceil, floor, truncate
* operators: +-*/√
* conversions: promotion, demotion
* helpers: arithmic_signum, sign_bit, successor, predecessor
