{-# LANGUAGE  Arrows, DoRec, EmptyDataDecls, FlexibleContexts #-}

module LangDef where

import qualified Data.Set as Set

import Control.Arrow

import UU.Pretty

import Language.Grammars.SyntaxMacros
import Language.Grammars.Grammar

import Language.Grammars.SyntaxMacros.Scanner

import LangSem
import Utils


prds = proc () -> do
         rec  root    <- addNT -<  [  prd (`semAGItf` ()) $ ch_expr<=>exp  <.> prdEnd  ] 

              exp     <- addNT -<  [  prd semLet $ trm "let" <.> ch_lnm<=>var  <.>  trm "=" <.> ch_val<=>exp <.> 
                                                   trm "in"  <.> ch_body<=>exp <.> prdEnd   
                                   ,  prd semAdd $ ch_ae1<=>term <.> trm "+"  <.> ch_ae2<=>exp <.> prdEnd
                                   ,  prdId term  ]
                                 
              term    <- addNT -<  [  prd semMul $ ch_me1<=>term <.> trm "*"  <.> ch_me2<=>factor <.> prdEnd
                                   ,  prdId factor ]

              factor  <- addNT -<  [  prd semCst $ ch_cv<=>int  <.> prdEnd 
                                   ,  prd semVar $ ch_vnm<=>var <.> prdEnd ]

         exportNTs -< Export root $   ntExp     ^=  exp     ^| 
                                      ntTerm    ^=  term    ^|
                                      ntFactor  ^=  factor  ^|  
                                      ntNil 



gramOpts :: ScanOpts
gramOpts
  =  defaultScanOpts
        {   scoKeywordsTxt      =   Set.fromList ["let", "in"]
        ,   scoSpecChars        =   Set.fromList "=+*"
        ,   scoDollarIdent      =   True
        }

