import qualified Data.Set as Set

import Control.Arrow

import UU.Pretty

import LangDef
import LangSem
import LangExt


import Language.Grammars.SyntaxMacros
import Language.Grammars.SyntaxMacros.Scanner

import Language.Grammars.AspectAG


gram = closeGram prds

test1 = do
        tokens <- scanFile gramOpts "prog.src"
        let (Ok res) = (parse . compile ) gram tokens
        print $ res # spp
        print $ res # sval



gram' = closeGram (extendGram prds prds') 

test2 = do
        tokens <- scanFile (gramOpts' gramOpts) "prog2.src"
        case ( parse . compile ) gram' tokens of
           (Ok res) -> do print $ res # spp
                          print $ res # sval
           (Rep _ err) -> print err


main = test1 >> test2 


