# Changelog
All notable changes to the `align-equal` project will be documented in this file.

## [1.0.1.0] - 2025-04-03

### Added
- Added a test suite using HSpec (`test/Spec.hs`) to validate core functions (`prefixLength`, `adjustLine`, `adjustText`).

### Changed
- Improved `adjustText` function:
  - Now returns the original text unchanged if it's empty or contains no lines with `'='`.
  - Updated function documentation and doctests to reflect this behavior.

### Removed
- Removed an unnecessary `newText` binding in `adjustText` for cleaner logic.

## [1.0.0] - 2025-03-31

### Changed:
- **`prefixLength`**: Changed return type from `Int` to `Maybe Int`. Now returns `Nothing` if no '=' is found, and `Just` the length of the prefix before the first '=' if it exists. This is a breaking change.
- Updated documentation for **`prefixLength`** and **`adjustText`** to reflect the new behavior.
- Bumped package version to `1.0.0` to reflect a breaking change in the API.

### Fixed:
- Properly handles lines without '=' in **`adjustText`** and **`prefixLength`**.

## [0.1.1.1] - 2025-03-31

### Added:
- Expanded `README.md` with a detailed description of the tool.
- Included Vim usage instructions with examples.

### Miscellaneous:
- Bumped version to `0.1.1.1` in `align-equal.cabal`.

## [0.1.1.0] - 2025-03-27

### Added:
- Extracted core functions into a separate library module (`Data.Text.AlignEqual`).
  - Refactored original `Main.hs` into executable and library components.
  - Added `src/Data/Text/AlignEqual.hs` with core text alignment logic.
  - Updated `app/Main.hs` to import and use `Data.Text.AlignEqual`.
  - Adjusted `.cabal` file to include a new library section and dependencies.
- Added Haddock documentation for `Data.Text.AlignEqual`.
  - Documented module purpose, `prefixLength`, `adjustLine`, and `adjustText` with descriptions, examples, and parameter annotations.
- Included `CHANGELOG.md` in the package documentation via `extra-doc-files` in `.cabal`.
- Maintained compatibility with the existing executable.

## [0.1.0.1] - 2025-03-10

### Fixed:
- Relaxed `base` dependency constraint to `>=4.17 && <4.19`.
- Removed duplicate `extra-doc-files` entry in `.cabal` file.

### Added:
- `README.md` with credit to Gabriella Gonzalez.
- Source repository link to `hub.darcs.net` in `.cabal` file.

## [0.1.0.0] - 2025-03-10

### Initial Release:
- Basic functionality for aligning text with equal signs.
  - Implemented as a standalone executable in `Main.hs`.
  - Initial project setup with `.cabal` and `LICENSE` files.
