{-# LANGUAGE OverloadedStrings #-}

module Main where

import           Data.Text            (Text)
import qualified Data.Text            as T
import           Data.Text.AlignEqual
import           Test.Hspec

main :: IO ()
main = hspec spec

spec :: Spec
spec = do
  describe "prefixLength" $ do
    it "returns Just length for lines containing '='" $ do
      prefixLength "key=value" `shouldBe` Just 3
      prefixLength "a=b" `shouldBe` Just 1
      prefixLength "foo=bar=baz" `shouldBe` Just 3

    it "returns Nothing for lines without '='" $ do
      prefixLength "noequals" `shouldBe` Nothing
      prefixLength "" `shouldBe` Nothing

  describe "adjustLine" $ do
    it "pads the prefix to match the desired length" $ do
      adjustLine 5 "key=value" `shouldBe` "key  =value"
      adjustLine 3 "a=b" `shouldBe` "a  =b"

    it "does not add spaces if the prefix is already at the desired length" $ do
      adjustLine 3 "foo=bar" `shouldBe` "foo=bar"

    it "handles lines without '=' correctly" $ do
      adjustLine 5 "noequals" `shouldBe` "noequals"

  describe "adjustText" $ do
    it "aligns '=' across multiple lines" $ do
      adjustText "key=value\na=b" `shouldBe` "key=value\na  =b"
      adjustText "x=y\nlong=var" `shouldBe` "x   =y\nlong=var"

    it "leaves lines without '=' unchanged" $ do
      adjustText "hello\nworld" `shouldBe` "hello\nworld"

    it "handles empty input correctly" $ do
      adjustText "" `shouldBe` ""
