{-# LANGUAGE DeriveDataTypeable #-}
{-# LANGUAGE DeriveGeneric      #-}
{-# LANGUAGE OverloadedStrings  #-}
{-# LANGUAGE RecordWildCards    #-}
{-# LANGUAGE TypeFamilies       #-}

{-# OPTIONS_GHC -fno-warn-unused-imports #-}
{-# OPTIONS_GHC -fno-warn-unused-binds   #-}
{-# OPTIONS_GHC -fno-warn-unused-matches #-}

-- Derived from AWS service descriptions, licensed under Apache 2.0.

-- |
-- Module      : Network.AWS.CodePipeline.PutThirdPartyJobSuccessResult
-- Copyright   : (c) 2013-2016 Brendan Hay
-- License     : Mozilla Public License, v. 2.0.
-- Maintainer  : Brendan Hay <brendan.g.hay@gmail.com>
-- Stability   : auto-generated
-- Portability : non-portable (GHC extensions)
--
-- Represents the success of a third party job as returned to the pipeline by a job worker. Only used for partner actions.
module Network.AWS.CodePipeline.PutThirdPartyJobSuccessResult
    (
    -- * Creating a Request
      putThirdPartyJobSuccessResult
    , PutThirdPartyJobSuccessResult
    -- * Request Lenses
    , ptpjsrContinuationToken
    , ptpjsrExecutionDetails
    , ptpjsrCurrentRevision
    , ptpjsrJobId
    , ptpjsrClientToken

    -- * Destructuring the Response
    , putThirdPartyJobSuccessResultResponse
    , PutThirdPartyJobSuccessResultResponse
    ) where

import           Network.AWS.CodePipeline.Types
import           Network.AWS.CodePipeline.Types.Product
import           Network.AWS.Lens
import           Network.AWS.Prelude
import           Network.AWS.Request
import           Network.AWS.Response

-- | Represents the input of a put third party job success result action.
--
-- /See:/ 'putThirdPartyJobSuccessResult' smart constructor.
data PutThirdPartyJobSuccessResult = PutThirdPartyJobSuccessResult'
    { _ptpjsrContinuationToken :: !(Maybe Text)
    , _ptpjsrExecutionDetails  :: !(Maybe ExecutionDetails)
    , _ptpjsrCurrentRevision   :: !(Maybe CurrentRevision)
    , _ptpjsrJobId             :: !Text
    , _ptpjsrClientToken       :: !Text
    } deriving (Eq,Read,Show,Data,Typeable,Generic)

-- | Creates a value of 'PutThirdPartyJobSuccessResult' with the minimum fields required to make a request.
--
-- Use one of the following lenses to modify other fields as desired:
--
-- * 'ptpjsrContinuationToken'
--
-- * 'ptpjsrExecutionDetails'
--
-- * 'ptpjsrCurrentRevision'
--
-- * 'ptpjsrJobId'
--
-- * 'ptpjsrClientToken'
putThirdPartyJobSuccessResult
    :: Text -- ^ 'ptpjsrJobId'
    -> Text -- ^ 'ptpjsrClientToken'
    -> PutThirdPartyJobSuccessResult
putThirdPartyJobSuccessResult pJobId_ pClientToken_ =
    PutThirdPartyJobSuccessResult'
    { _ptpjsrContinuationToken = Nothing
    , _ptpjsrExecutionDetails = Nothing
    , _ptpjsrCurrentRevision = Nothing
    , _ptpjsrJobId = pJobId_
    , _ptpjsrClientToken = pClientToken_
    }

-- | A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a successful job provides to identify a partner action in progress. Future jobs will use this token in order to identify the running instance of the action. It can be reused to return additional information about the progress of the partner action. When the action is complete, no continuation token should be supplied.
ptpjsrContinuationToken :: Lens' PutThirdPartyJobSuccessResult (Maybe Text)
ptpjsrContinuationToken = lens _ptpjsrContinuationToken (\ s a -> s{_ptpjsrContinuationToken = a});

-- | Undocumented member.
ptpjsrExecutionDetails :: Lens' PutThirdPartyJobSuccessResult (Maybe ExecutionDetails)
ptpjsrExecutionDetails = lens _ptpjsrExecutionDetails (\ s a -> s{_ptpjsrExecutionDetails = a});

-- | Undocumented member.
ptpjsrCurrentRevision :: Lens' PutThirdPartyJobSuccessResult (Maybe CurrentRevision)
ptpjsrCurrentRevision = lens _ptpjsrCurrentRevision (\ s a -> s{_ptpjsrCurrentRevision = a});

-- | The ID of the job that successfully completed. This is the same ID returned from PollForThirdPartyJobs.
ptpjsrJobId :: Lens' PutThirdPartyJobSuccessResult Text
ptpjsrJobId = lens _ptpjsrJobId (\ s a -> s{_ptpjsrJobId = a});

-- | The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.
ptpjsrClientToken :: Lens' PutThirdPartyJobSuccessResult Text
ptpjsrClientToken = lens _ptpjsrClientToken (\ s a -> s{_ptpjsrClientToken = a});

instance AWSRequest PutThirdPartyJobSuccessResult
         where
        type Rs PutThirdPartyJobSuccessResult =
             PutThirdPartyJobSuccessResultResponse
        request = postJSON codePipeline
        response
          = receiveNull PutThirdPartyJobSuccessResultResponse'

instance Hashable PutThirdPartyJobSuccessResult

instance NFData PutThirdPartyJobSuccessResult

instance ToHeaders PutThirdPartyJobSuccessResult
         where
        toHeaders
          = const
              (mconcat
                 ["X-Amz-Target" =#
                    ("CodePipeline_20150709.PutThirdPartyJobSuccessResult"
                       :: ByteString),
                  "Content-Type" =#
                    ("application/x-amz-json-1.1" :: ByteString)])

instance ToJSON PutThirdPartyJobSuccessResult where
        toJSON PutThirdPartyJobSuccessResult'{..}
          = object
              (catMaybes
                 [("continuationToken" .=) <$>
                    _ptpjsrContinuationToken,
                  ("executionDetails" .=) <$> _ptpjsrExecutionDetails,
                  ("currentRevision" .=) <$> _ptpjsrCurrentRevision,
                  Just ("jobId" .= _ptpjsrJobId),
                  Just ("clientToken" .= _ptpjsrClientToken)])

instance ToPath PutThirdPartyJobSuccessResult where
        toPath = const "/"

instance ToQuery PutThirdPartyJobSuccessResult where
        toQuery = const mempty

-- | /See:/ 'putThirdPartyJobSuccessResultResponse' smart constructor.
data PutThirdPartyJobSuccessResultResponse =
    PutThirdPartyJobSuccessResultResponse'
    deriving (Eq,Read,Show,Data,Typeable,Generic)

-- | Creates a value of 'PutThirdPartyJobSuccessResultResponse' with the minimum fields required to make a request.
--
putThirdPartyJobSuccessResultResponse
    :: PutThirdPartyJobSuccessResultResponse
putThirdPartyJobSuccessResultResponse = PutThirdPartyJobSuccessResultResponse'

instance NFData PutThirdPartyJobSuccessResultResponse
