# What is it for?

Assume you have some type

```haskell
data Animal =
    Animal
    { species :: String
    , weight  :: Double
    , age     :: NominalDiffTime
    }
```

And you would like to produce this value from some data (e.g. query
parameters). There can be some warnigns or value can not be produced
at all. It would be great to have some simple tool to notify about
warnings and/or fail computation.

Like that:

```haskell
spc = "Parastratiosphecomyia stratiosphecomyioides"
w = 100
a = 27234

animal = Animal
         <$> (if length spc > 20
              then fwarn "Name is too long" spc
              else if spc == ""
                   then ffail "Name can not be empty"
                   else fsucc spc)
         <*> (if w < 0
              then ffail "Weight can not be negative"
              else fsucc w)
         <*> (if a < 0
              then ffail "Age can not be negative"
              else fsucc a)
```

Now you can inspect the value we have got

```haskell
λ> animal
Fail ["Name is too long"] (Just (Animal {species = "Parastratiosphecomyia stratiosphecomyioides", weight = 100.0, age = 27234}))
λ> getSucc animal
Just (Animal {species = "Parastratiosphecomyia stratiosphecomyioides", weight = 100.0, age = 27234})
λ> getFail animal
Just ["Name is too long"]
```

Here is another simple examples:

```haskell
λ> (,) <$> ffail "oups" <*> ffail "duh"
Fail ["oups","duh"] Nothing
λ> (,) <$> fwarn "oups" "hello" <*> fwarn "duh" "world"
Fail ["oups","duh"] (Just ("hello","world"))
λ> (,) <$> fsucc "hello" <*> fwarn "duh" "world"
Fail ["duh"] (Just ("hello","world"))
λ> (,) <$> fsucc "hello" <*> fsucc "world"
Success ("hello","world")
```