.\" Man page generated from reStructuredText.
.
.
.nr rst2man-indent-level 0
.
.de1 rstReportMargin
\\$1 \\n[an-margin]
level \\n[rst2man-indent-level]
level margin: \\n[rst2man-indent\\n[rst2man-indent-level]]
-
\\n[rst2man-indent0]
\\n[rst2man-indent1]
\\n[rst2man-indent2]
..
.de1 INDENT
.\" .rstReportMargin pre:
. RS \\$1
. nr rst2man-indent\\n[rst2man-indent-level] \\n[an-margin]
. nr rst2man-indent-level +1
.\" .rstReportMargin post:
..
.de UNINDENT
. RE
.\" indent \\n[an-margin]
.\" old: \\n[rst2man-indent\\n[rst2man-indent-level]]
.nr rst2man-indent-level -1
.\" new: \\n[rst2man-indent\\n[rst2man-indent-level]]
.in \\n[rst2man-indent\\n[rst2man-indent-level]]u
..
.TH "ARX" "1" "%F" "0.3.3" "arx"
.SH NAME
arx \- archived execution
.SH SYNOPSIS
.INDENT 0.0
.INDENT 3.5
.sp
.EX
arx (\-h | \-[?] | \-\-help)
arx (\-v | \-\-version)
arx shdat (\-b <size>)? (\-o <output file>)? < input
arx shdat (\-b <size>)? (\-o <output file>)? <input file>+
arx tmpx <option,archive>* (//+ <command> (//+ <option,archive>*)?)?
.EE
.UNINDENT
.UNINDENT
.SH DESCRIPTION
.sp
A UNIX executable is a simple thing \-\- a file the kernel can execute, one way
or another, via an interpreter or directly as object code. Every executable
induces a family of executions \-\- instances of execution with different
command line arguments, with different files in the working directory and with
different environment variables present.
.sp
The \fIarx\fP tool captures the parameters of an execution and encodes them as an
executable, making for easy, consistent transfer and repetition of a
particular run. The generated executable ensures that each run occurs in a
freshly allocated temporary directory, with only the desired files in scope;
it uses traps to ensure the cleanup of this directory; and its format is a
simple POSIX shell script, relying on just a few shell tools.
.SH DEPENDENCIES
.sp
The \fIarx\fP tool relies on the presence of \fIsed\fP, \fItr\fP, \fIdate\fP, \fIhead\fP, \fItar\fP,
\fIhexdump\fP and \fIsh\fP\&. When unpacking tar archives, it may use the \fI\-j\fP or \fI\-z\fP
(\fIbzip2\fP and \fIgzip\fP, respectively) options of \fItar\fP\&. Scripts have been tested
with \fIdash\fP and the GNU tools as well as the \fIsh\fP implementation and userland
tools that are part of \fIbusybox\fP\&.
.SH APPLICATION
.sp
The \fItmpx\fP subcommand of \fIarx\fP offers a variety of options for bundling code
and a task to run. The \fIshdat\fP subcommand exposes the lower\-level
functionality of encoding binary data in a shell script that outputs that
binary data, using HERE documents and some odd replacement rules for nulls.
.sp
Scripts generated by \fItmpx\fP and \fIshdat\fP may be fed to \fIsh\fP over \fISTDIN\fP to
execute them. This can be helpful when using \fIssh\fP and \fIsudo\fP to set up an
execution context; for example:
.INDENT 0.0
.INDENT 3.5
.sp
.EX
arx tmpx ... | ssh user@host.com sudo sh
.EE
.UNINDENT
.UNINDENT
.sp
Scripts generated by \fItmpx\fP will pass their arguments to the contained script
or command. To pass arguments when piping to \fIsh\fP, use \fI\-s\fP:
.INDENT 0.0
.INDENT 3.5
.sp
.EX
arx tmpx ... | ssh user@host.com sudo sh \-s a b c
.EE
.UNINDENT
.UNINDENT
.sp
Some arguments to the generated script will be treated specially, namely,
\fB\-\-extract\fP, \fB\-\-no\-rm\fP and \fB\-\-no\-run\fP\&. Please see the section on Passing
Arguments, below, for more information about these options.
.SH ARX COMMANDLINE PROCESSING
.sp
For all subcommands, when options overlap in their effect \-\- for example,
setting the output with \fB\-o\fP \-\- the rightmost option takes precedence.
Whenever \fB\-h\fP, \fB\-?\fP or \fB\-\-help\fP is present on the command line, help is
displayed and the program exits.
.sp
When paths are specified on an \fBarx\fP command line, they must be qualified,
starting with \fB/\fP, \fB\&./\fP or \fB\&../\fP\&. This simplifies the command line
syntax, overall, without introducing troublesome ambiguities.
.SH TMPX
.sp
The \fItmpx\fP subcommand bundles together archives, environment settings and an
executable or shell command in to a Bourne\-compatible script that runs the
command or executable in a temporary directory, after having unpacked the
archives and set the environment.
.sp
Any number of file path arguments may be specified; they will be interpreted
as tar archives to include in bundled script. If \fB\-\fP is given, then STDIN
will be included as an archive stream. If no arguments are given, it is
assumed that no archives are desired and only the command and environment are
bundled.
.sp
The temporary directory created by the script is different for each
invocation, with a name of the form \fB/tmp/tmpx\-<timestamp>\-<randomhex>\fP\&. The
timestamp format is %Y.%m.%dT%H.%M.%SZ, in UTC. One happy consequence of this
is that earlier jobs sort ASCIIbetically before later jobs. After execution,
the temporary directory is removed (or not, depending on the \fB\-rm[10!_]\fP
family of options).
.INDENT 0.0
.INDENT 3.5
.INDENT 0.0
.TP
.B \fB\-rm0\fP, \fB\-rm1\fP, \fB\-rm_\fP, \fB\-rm!\fP
By default, the temporary directory created by the script will be deleted
no matter the exit status status of the task. These options cause a script
to be generated that deletes the temporary directory only on success, only
on failure, always (the default) or never.
.TP
.B \fB\-\-shared\fP
Causes the temporary directory to be identified by a hash of the ARX
archive, instead of by date and time. Different runs of the same archive
will share the same directory. Note that this implies shared state and
every disadvantage thereof.
.TP
.B \fB\-b <size>\fP
Please see the documentation for this option, shared with \fIshdat\fP, below.
.TP
.B \fB\-o <path>\fP
By default, the generated script is sent to STDOUT. With \fB\-o\fP, output is
redirected to the given path.
.TP
.B \fB\-e <path>\fP
Causes the file specified to be packaged as the task to be run. A binary
executable, a Ruby script or a longish shell script all fit here.
.UNINDENT
.UNINDENT
.UNINDENT
.sp
In addition to these options, arguments of the form \fBVAR=VALUE\fP are
recognized as environment mappings and stored away in the script, to be
sourced on execution.
.sp
Without \fB\-e\fP, the \fItmpx\fP subcommand tries to find the task to be run as a
sequence of arguments delimited by a run of slashes. The following forms are
all recognized:
.INDENT 0.0
.INDENT 3.5
.sp
.EX
arx tmpx  ...some args... // ...command...
arx tmpx  ...some args... // ...command... // ...more args...
arx tmpx // ...command... // ...some args...
.EE
.UNINDENT
.UNINDENT
.sp
The slash runs must have the same number of slashes and must be the longest
continuous runs of slashes on the command line. The command will be included
as\-is in a Bourne shell script.
.SH SHDAT
.sp
The \fIshdat\fP subcommand translates binary data in to a shell script which
outputs the binary data. The data is encoded in HERE documents in such a way
that data without NULs is not changed and that data with NULs is minimally
expanded: about 1% for randomish data like compressed tarballs and about 10%
in pathological cases.
.sp
The \fIshdat\fP subcommand can be given any number of paths, which will be
concatenated in the order given. If no path is given, or if \fB\-\fP is given,
then STDIN will be read.
.INDENT 0.0
.INDENT 3.5
.INDENT 0.0
.TP
.B \fB\-b <size>\fP
The size of data chunks to place in each HERE document. The argument is a
positive integer followed by suffixes like \fBB\fP, \fBK\fP, \fBKiB\fP, \fBM\fP
and \fBMiB\fP, in the manner of \fBdd\fP, \fBhead\fP and many other tools. The
default is 4MiB.  This is unlikely to make a difference for you unless the
generated script is intended to be run on a memory\-constrained system.
.TP
.B \fB\-o <path>\fP
By default, the generated script is sent to STDOUT. With \fB\-o\fP, output is
redirected to the given path.
.UNINDENT
.UNINDENT
.UNINDENT
.SH EXAMPLES
.INDENT 0.0
.INDENT 3.5
.sp
.EX
# Installer script that preserves failed builds.
git archive HEAD | bzip2 | arx tmpx \-rm0 \- // make install > go.sh
# Now install as root; but don\(aqt log in as root.
cat ./go.sh | ssh joey@hostname sudo /bin/sh

# Variation of the above.
git archive HEAD | bzip2 | arx tmpx \-rm0 \- \-e ./build\-script.py > go.sh

# Bundle an instance of an application with DB credentials and run it.
arx tmpx \-rm! ./app.tbz ./stage\-info.tgz // rake start | ssh ...

# Get dump of linking info for build that works here but not there.
arx tmpx ./server\-build.tgz LD_DEBUG=files // ./bin/start | ssh ...

# Test out Cabal source distribution of this package:
arx tmpx // \(aqcd arx\-* && cabal configure && cabal build\(aq // \e
         \-rm0 ./dist/arx\-0.0.0.tar.gz | sh
.EE
.UNINDENT
.UNINDENT
.SH PASSING ARGUMENTS TO GENERATED SCRIPTS
.sp
The scripts generated by \fItmpx\fP treat some arguments as special, internal
options, to allow for inspecting them should there be a need to determine
their contents.
.INDENT 0.0
.INDENT 3.5
.INDENT 0.0
.TP
.B \fB\-\-extract\fP
Unpack the data in the present directory and do nothing else.
.TP
.B \fB\-\-no\-rm\fP
Run the script as normal but do not delete the generated temporary
directory.
.TP
.B \fB\-\-no\-run\fP
Unpack into a temporary directory as normal but do not run the user\(aqs
command.
.UNINDENT
.UNINDENT
.UNINDENT
.sp
To prevent arguments from being specially treated, use \fB//\fP in the argument
list:
.INDENT 0.0
.INDENT 3.5
.sp
.EX
a\-tmpx\-script.sh \-\-no\-rm // a b c \-\-extract
.EE
.UNINDENT
.UNINDENT
.sp
In the above example, \fB\-\-extract\fP will be passed to the inner command, in
the same way as \fBa\fP, \fBb\fP, \fBc\fP\&. The following example causes \fBab\fP,
\fBc\fP and \fB\-\-no\-rm\fP to be printed one after another, each on their own line.
.INDENT 0.0
.INDENT 3.5
.sp
.EX
arx tmpx // printf \(dq\(aq%s\en\(aq\(dq \(aq\(dq$@\(dq\(aq | sh \-s // ab c \-\-no\-rm
.EE
.UNINDENT
.UNINDENT
.SH NOTES
.sp
The timestamp is not the common ISO 8601 format, %Y\-%m\-%dT%H:%M:%SZ, because
of software and build processes that attach special meaning to colons in
pathnames.
.SH BUGS
.sp
The command line parser offers no hints or help of any kind; it fails with the
simple message \(dqargument error\(dq. The two most common mistakes I make are:
.INDENT 0.0
.IP \(bu 2
Not qualifying paths with \fB/\fP, \fB\&./\fP or \fB\&../\fP\&.
.IP \(bu 2
Not specifying a subcommand (\fItmpx\fP or \fIshdat\fP).
.UNINDENT
.SH AUTHOR
Jason Dusek
.SH COPYRIGHT
2011, Jason Dusek
.\" Generated by docutils manpage writer.
.
