{-# LANGUAGE FlexibleContexts #-}
{-# LANGUAGE FlexibleInstances #-}
{-# LANGUAGE MultiParamTypeClasses #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE TypeApplications #-}

module Aztecs.GL.Mesh
  ( -- * Meshes
    OfMesh (..),
    Mesh (..),
  )
where

import Aztecs
import Aztecs.GL.Internal
import Control.Monad.IO.Class
import Prelude hiding (lookup)

-- | Mesh component
newtype Mesh = Mesh {unMesh :: IO MeshState}

instance (MonadIO m) => Component m Mesh where
  componentOnInsert e mesh = do
    meshState <- liftIO $ unMesh mesh
    insert e $ bundle meshState
    mOfMat <- lookup e
    case mOfMat of
      Just (OfMaterial matE) -> registerRenderable e e matE
      Nothing -> do
        mMatState <- lookup @_ @MaterialState e
        case mMatState of
          Just _ -> registerRenderable e e e
          Nothing -> return ()

  componentOnRemove e _ = do
    mOfMat <- lookup e
    case mOfMat of
      Just (OfMaterial matE) -> unregisterRenderable e e matE
      Nothing -> do
        mMatState <- lookup @_ @MaterialState e
        case mMatState of
          Just _ -> unregisterRenderable e e e
          Nothing -> return ()
