{-# LANGUAGE FlexibleInstances #-}
{-# LANGUAGE MultiParamTypeClasses #-}

module Aztecs.GL.D2.Image.Internal (ImageState (..)) where

import Aztecs
import Aztecs.Transform
import Control.Monad
import qualified Graphics.Rendering.OpenGL as GL
import Prelude hiding (lookup)

-- | Image state component
data ImageState = ImageState
  { imageTexture :: !GL.TextureObject,
    imageSize :: !(V2 Float)
  }

instance (Monad m) => Component m ImageState
