{-|
Module      : Text.BBCode
Description : Main module exporting builder interface and types
License     : GPL-3
Stability   : experimental
Portability : GHC

Here is a longer description of this module, containing some
commentary with @some markup@.
-}
module Text.BBCode
  ( -- Builder
    nl
  , text
  , doc
  , hr
  , br
  , clear
  , listEl
  , bold
  , italic
  , underline
  , strikethrough
  , indent
  , nfo
  , oneline
  , code
  , pre
  , box
  , image
  , quote
  , spoiler
  , list
  , boxAlign
  , imageAlign
  , quoteNamed
  , spoilerNamed
  , listFlavor
  , color
  , url
  , size
  , align
  , font
  -- Types
  , BBCode (..)
  , El (..)
  , IsArgument (..)
  , AlignPosition (..)
  , ListFlavor (..)
  , ImagePosition (..)
  , BoxPosition (..)
  -- Pretty
  , pretty
  -- Parser
  , bbcode
  , runParserMaybeEnv
  )
where

import Text.BBCode.Internal.Builder
import Text.BBCode.Internal.Parser (bbcode, runParserMaybeEnv)
import Text.BBCode.Internal.Pretty
import Text.BBCode.Internal.Types
