{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE RecordWildCards #-}

module Database.Bloodhound.Internal.Versions.OpenSearch2.Types.PointInTime where

import Database.Bloodhound.Internal.Utils.Imports
import Database.Bloodhound.Internal.Versions.Common.Types.Nodes (ShardResult)

data OpenPointInTimeResponse = OpenPointInTimeResponse
  { oos2PitId :: Text,
    oos2Shards :: ShardResult,
    oos2CreationTime :: POSIXTime
  }
  deriving stock (Eq, Show)

instance ToJSON OpenPointInTimeResponse where
  toJSON OpenPointInTimeResponse {..} =
    object ["pit_id" .= oos2PitId, "_shards" .= oos2Shards, "creation_time" .= oos2CreationTime]

instance FromJSON OpenPointInTimeResponse where
  parseJSON (Object o) =
    OpenPointInTimeResponse
      <$> o .: "pit_id"
      <*> o .: "_shards"
      <*> o .: "creation_time"
  parseJSON x = typeMismatch "OpenPointInTimeResponse" x

openPointInTimeIdLens :: Lens' OpenPointInTimeResponse Text
openPointInTimeIdLens = lens oos2PitId (\x y -> x {oos2PitId = y})

openPointInTimeShardsLens :: Lens' OpenPointInTimeResponse ShardResult
openPointInTimeShardsLens = lens oos2Shards (\x y -> x {oos2Shards = y})

openPointInTimeCreationTimeLens :: Lens' OpenPointInTimeResponse POSIXTime
openPointInTimeCreationTimeLens = lens oos2CreationTime (\x y -> x {oos2CreationTime = y})

data ClosePointInTime = ClosePointInTime
  { cPitId :: Text
  }
  deriving stock (Eq, Show)

instance ToJSON ClosePointInTime where
  toJSON ClosePointInTime {..} =
    object ["id" .= cPitId]

instance FromJSON ClosePointInTime where
  parseJSON (Object o) = ClosePointInTime <$> o .: "id"
  parseJSON x = typeMismatch "ClosePointInTime" x

closePointInTimeIdLens :: Lens' ClosePointInTime Text
closePointInTimeIdLens = lens cPitId (\x y -> x {cPitId = y})

data ClosePointInTimeResponse = ClosePointInTimeResponse
  { succeeded :: Bool,
    numFreed :: Int
  }
  deriving stock (Eq, Show)

instance ToJSON ClosePointInTimeResponse where
  toJSON ClosePointInTimeResponse {..} =
    object
      [ "succeeded" .= succeeded,
        "num_freed" .= numFreed
      ]

instance FromJSON ClosePointInTimeResponse where
  parseJSON (Object o) = do
    succeeded' <- o .: "succeeded"
    numFreed' <- o .: "num_freed"
    return $ ClosePointInTimeResponse succeeded' numFreed'
  parseJSON x = typeMismatch "ClosePointInTimeResponse" x

closePointInTimeSucceededLens :: Lens' ClosePointInTimeResponse Bool
closePointInTimeSucceededLens = lens succeeded (\x y -> x {succeeded = y})

closePointInTimeNumFreedLens :: Lens' ClosePointInTimeResponse Int
closePointInTimeNumFreedLens = lens numFreed (\x y -> x {numFreed = y})
