module Maze where

import Brillo


coords :: [Point]
coords =
  [ (0, 1)
  , (-9, -11)
  , (-9, -10)
  , (-9, -9)
  , (-9, -8)
  , (-9, -7)
  , (-9, -6)
  , (-9, -5)
  , (-9, -4)
  , (-9, -3)
  , (-9, -1)
  , (-9, 1)
  , (-9, 3)
  , (-9, 4)
  , (-9, 5)
  , (-9, 6)
  , (-9, 7)
  , (-9, 8)
  , (-9, 9)
  , (9, -10)
  , (9, -9)
  , (9, -8)
  , (9, -7)
  , (9, -6)
  , (9, -5)
  , (9, -4)
  , (9, -3)
  , (9, -1)
  , (9, 1)
  , (9, 3)
  , (9, 4)
  , (9, 5)
  , (9, 6)
  , (9, 7)
  , (9, 8)
  , (9, 9)
  , (-9, -11)
  , (-8, -11)
  , (-7, -11)
  , (-6, -11)
  , (-5, -11)
  , (-4, -11)
  , (-3, -11)
  , (-2, -11)
  , (-1, -11)
  , (0, -11)
  , (1, -11)
  , (2, -11)
  , (3, -11)
  , (4, -11)
  , (5, -11)
  , (6, -11)
  , (7, -11)
  , (8, -11)
  , (9, -11)
  , (-9, 9)
  , (-8, 9)
  , (-7, 9)
  , (-6, 9)
  , (-5, 9)
  , (-4, 9)
  , (-3, 9)
  , (-2, 9)
  , (-1, 9)
  , (0, 9)
  , (1, 9)
  , (2, 9)
  , (3, 9)
  , (4, 9)
  , (5, 9)
  , (6, 9)
  , (7, 9)
  , (8, 9)
  , (9, 9)
  , (-2, 0)
  , (2, 0)
  , (1, 1)
  , (-1, 1)
  , (2, 1)
  , (-2, 1)
  , (-2, -1)
  , (-1, -1)
  , (0, -1)
  , (1, -1)
  , (2, -1)
  , (0, 3)
  , (0, 4)
  , (0, 5)
  , (0, 7)
  , (0, 8)
  , (0, -3)
  , (0, -4)
  , (0, -5)
  , (0, -7)
  , (0, -8)
  , (0, -9)
  , (1, 5)
  , (1, -3)
  , (1, -7)
  , (2, 3)
  , (2, 5)
  , (2, 7)
  , (2, -3)
  , (2, -5)
  , (2, -7)
  , (2, -9)
  , (3, 3)
  , (3, 7)
  , (3, -5)
  , (3, -9)
  , (4, 1)
  , (4, 2)
  , (4, 3)
  , (4, 4)
  , (4, 5)
  , (4, 7)
  , (4, -1)
  , (4, -2)
  , (4, -3)
  , (4, -5)
  , (4, -7)
  , (4, -8)
  , (4, -9)
  , (5, -9)
  , (6, 1)
  , (6, 2)
  , (6, 3)
  , (6, 5)
  , (6, 7)
  , (6, -1)
  , (6, -2)
  , (6, -3)
  , (6, -5)
  , (6, -6)
  , (6, -7)
  , (6, -9)
  , (7, 1)
  , (7, 3)
  , (7, 5)
  , (7, 7)
  , (7, -1)
  , (7, -3)
  , (7, -5)
  , (7, -9)
  , (8, 1)
  , (8, 3)
  , (8, -1)
  , (8, -3)
  , (8, -7)
  , (10, 1)
  , (10, -1)
  , (2, 0)
  , (-2, 0)
  , (-1, 1)
  , (1, 1)
  , (-2, 1)
  , (2, 1)
  , (2, -1)
  , (1, -1)
  , (0, -1)
  , (-1, -1)
  , (-2, -1)
  , (0, 3)
  , (0, 4)
  , (0, 5)
  , (0, 7)
  , (0, 8)
  , (0, -3)
  , (0, -4)
  , (0, -5)
  , (0, -7)
  , (0, -8)
  , (0, -9)
  , (-1, 5)
  , (-1, -3)
  , (-1, -7)
  , (-2, 3)
  , (-2, 5)
  , (-2, 7)
  , (-2, -3)
  , (-2, -5)
  , (-2, -7)
  , (-2, -9)
  , (-3, 3)
  , (-3, 7)
  , (-3, -5)
  , (-3, -9)
  , (-4, 1)
  , (-4, 2)
  , (-4, 3)
  , (-4, 4)
  , (-4, 5)
  , (-4, 7)
  , (-4, -1)
  , (-4, -2)
  , (-4, -3)
  , (-4, -5)
  , (-4, -7)
  , (-4, -8)
  , (-4, -9)
  , (-5, -9)
  , (-6, 1)
  , (-6, 2)
  , (-6, 3)
  , (-6, 5)
  , (-6, 7)
  , (-6, -1)
  , (-6, -2)
  , (-6, -3)
  , (-6, -5)
  , (-6, -6)
  , (-6, -7)
  , (-6, -9)
  , (-7, 1)
  , (-7, 3)
  , (-7, 5)
  , (-7, 7)
  , (-7, -1)
  , (-7, -3)
  , (-7, -5)
  , (-7, -9)
  , (-8, 1)
  , (-8, 3)
  , (-8, -1)
  , (-8, -3)
  , (-8, -7)
  , (-10, 1)
  , (-10, -1)
  ]


pelletsL :: [Point]
pelletsL =
  [ (-8, -10)
  , (-7, -10)
  , (-6, -10)
  , (-5, -10)
  , (-4, -10)
  , (-3, -10)
  , (-2, -10)
  , (-1, -10)
  , (-5, -8)
  , (-5, -7)
  , (-5, -6)
  , (-5, -5)
  , (-5, -4)
  , (-5, -3)
  , (-5, -2)
  , (-5, -1)
  , (-5, 0)
  , (-5, 1)
  , (-5, 2)
  , (-5, 3)
  , (-5, 4)
  , (-5, 5)
  , (-5, 6)
  , (-5, 7)
  , (-5, 8)
  , (-8, -9)
  , (-8, -8)
  , (-7, -8)
  , (-6, -8)
  , (-7, -7)
  , (-7, -6)
  , (-8, -5)
  , (-8, -4)
  , (-1, -4)
  , (-2, -4)
  , (-3, -4)
  , (-4, -4)
  , (-6, -4)
  , (-7, -4)
  , (-8, -4)
  , (-1, -5)
  , (-5, -6)
  , (-1, -6)
  , (-2, -6)
  , (-3, -6)
  , (-4, -6)
  , (-3, -7)
  , (-3, -8)
  , (-1, -8)
  , (-2, -8)
  , (-1, -9)
  , (-1, 4)
  , (-1, 6)
  , (-1, 7)
  , (-1, 8)
  , (-2, 4)
  , (-2, 6)
  , (-2, 8)
  , (-3, 4)
  , (-3, 5)
  , (-3, 6)
  , (-3, 8)
  , (-4, 6)
  , (-4, 8)
  , (-6, 4)
  , (-6, 6)
  , (-6, 8)
  , (-7, 4)
  , (-7, 6)
  , (-7, 8)
  , (-8, 4)
  , (-8, 5)
  , (-8, 6)
  , (-8, 8)
  , (8, -10)
  , (7, -10)
  , (6, -10)
  , (5, -10)
  , (4, -10)
  , (3, -10)
  , (2, -10)
  , (1, -10)
  , (5, -8)
  , (5, -7)
  , (5, -6)
  , (5, -5)
  , (5, -4)
  , (5, -3)
  , (5, -2)
  , (5, -1)
  , (5, 0)
  , (5, 1)
  , (5, 2)
  , (5, 3)
  , (5, 4)
  , (5, 5)
  , (5, 6)
  , (5, 7)
  , (5, 8)
  , (8, -9)
  , (8, -8)
  , (7, -8)
  , (6, -8)
  , (7, -7)
  , (7, -6)
  , (8, -5)
  , (8, -4)
  , (1, -4)
  , (2, -4)
  , (3, -4)
  , (4, -4)
  , (6, -4)
  , (7, -4)
  , (8, -4)
  , (1, -5)
  , (5, -6)
  , (1, -6)
  , (2, -6)
  , (3, -6)
  , (4, -6)
  , (3, -7)
  , (3, -8)
  , (1, -8)
  , (2, -8)
  , (1, -9)
  , (1, 4)
  , (1, 6)
  , (1, 7)
  , (1, 8)
  , (2, 4)
  , (2, 6)
  , (2, 8)
  , (3, 4)
  , (3, 5)
  , (3, 6)
  , (3, 8)
  , (4, 6)
  , (4, 8)
  , (6, 4)
  , (6, 6)
  , (6, 8)
  , (7, 4)
  , (7, 6)
  , (7, 8)
  , (8, 4)
  , (8, 5)
  , (8, 6)
  , (8, 8)
  , (0, -10)
  , (0, 6)
  ]


powerPellet :: [Point]
powerPellet = [(-8, -6), (8, -6), (-8, 7), (8, 7)]


crossR :: [Point]
crossR =
  [ (1, 2)
  , (1, 6)
  , (3, 6)
  , (5, 6)
  , (8, 6)
  , (5, 8)
  , (8, 6)
  , (3, -4)
  , (5, -4)
  , (1, -6)
  , (3, -6)
  , (5, -6)
  , (7, -8)
  , (1, -10)
  , (-1, 2)
  , (-1, 6)
  , (-3, 6)
  , (-5, 6)
  , (-8, 6)
  , (-5, 8)
  , (-8, 6)
  , (-3, -4)
  , (-5, -4)
  , (-1, -6)
  , (-3, -6)
  , (-5, -6)
  , (-7, -8)
  , (-1, -10)
  , (-5, 4)
  , (5, 4)
  ]


renderS :: Point -> Picture
renderS (x, y) =
  Translate (x * 30) (y * 30) wallBlock
  where
    wallBlock = Color (dark blue) $ rectangleSolid 30 30


renderW :: [Point] -> Picture
renderW walls = Pictures [renderS w | w <- walls]
