# Bugsnag error reporter for Haskell

[![Hackage](https://img.shields.io/hackage/v/bugsnag.svg?style=flat)](https://hackage.haskell.org/package/bugsnag)
[![Stackage Nightly](http://stackage.org/package/bugsnag/badge/nightly)](http://stackage.org/nightly/package/bugsnag)
[![Stackage LTS](http://stackage.org/package/bugsnag/badge/lts)](http://stackage.org/lts/package/bugsnag)

Catch exceptions in your Haskell code and report then to Bugsnag.

## Configuration

```hs
let settings = defaultSettings "A_BUGSNAG_API_KEY"
```

## Manual Reporting

`Data.Bugsnag.Exception` is the type of actual exceptions included in the event
reported to Bugsnag. Constructing it directly can be useful to attach the
current source location as a stack frame.

```hs
let
  ex = defaultException
    { exception_errorClass = "Error"
    , exception_message = Just "message"
    , exception_stacktrace = [$(currentStackFrame) "myFunction"]
    }
```

In order to treat it like an actual Haskell `Exception` (including to report
it), wrap it in `AsException`:

```hs
notifyBugsnag settings $ AsException ex
```

## Catching & Throwing

Catch any exceptions, notify, and re-throw:

```hs
myFunction `withException` notifyBugsnag @SomeException settings
```

Throw a manually-built exception:

```hs
throwIO $ AsException ex
```

## Examples

- [Simple](./examples/simple/Main.hs)
- [Command-Line](./examples/cli/Main.hs)

Examples can be built locally with:

```console
stack build --flag bugsnag:examples
```

## `bugsnag-hs`

We depend on `bugsnag-hs` to define the types for the full reporting API
payload. Unfortunately, it exposes them from its own `Network.Bugsnag` module,
which conflicts with ourselves.

To get around this, we re-export that whole module as `Data.Bugsnag`. If you are
currently depending on `bugsnag-hs` and wish to use our package too, we
recommend you only depend on us and use its types through the `Data.Bugsnag`
re-export.

---

[CHANGELOG](./CHANGELOG.md) | [LICENSE](./LICENSE)
