module Main (main) where

import qualified Codec.Compression.BZip as BZ2
import           Criterion.Main
import qualified Data.ByteString.Lazy   as BSL

decompressFile :: FilePath -> IO BSL.ByteString
decompressFile = fmap BZ2.decompress . BSL.readFile

compressFile :: FilePath -> IO BSL.ByteString
compressFile = fmap BZ2.compress . BSL.readFile

main :: IO ()
main =
    defaultMain [ bgroup "decompress"
                      [ bench "decompress file" $ nfIO (decompressFile "test/data/sample1.bz2")
                      , bench "decompress file" $ nfIO (decompressFile "test/data/sample2.bz2")
                      , bench "decompress file" $ nfIO (decompressFile "test/data/sample3.bz2")
                      ]
                , bgroup "compress"
                      [ bench "compress file" $ nfIO (compressFile "test/data/sample1.ref")
                      , bench "compress file" $ nfIO (compressFile "test/data/sample2.ref")
                      , bench "compress file" $ nfIO (compressFile "test/data/sample3.ref")
                      ]
                ]
