# cached-io: cache a single IO action

Sometimes you have an action that does something really expensive
whose results don't change that much. This is a simple library that
lets you cache the output of that expensive action for a
developer-specified length of time.

`test/test-cachedIO.hs` shows a very basic usage example.

## Developing this library

All standardised tooling is provided by `flake.nix`.

```shell
nix develop
```

### Formatting code

| To format | use                                                                                          |
| --------- | -------------------------------------------------------------------------------------------- |
| `*.cabal` | [`cabal-fmt`](https://hackage.haskell.org/package/cabal-fmt) (`cabal-fmt --inplace *.cabal`) |
| `*.nix`   | [`nixpkgs-fmt`](https://github.com/nix-community/nixpkgs-fmt) (`nixpkgs-fmt *.nix`)          |

We have not yet chosen a formatter for Haskell source. For now, try to follow
the style of surrounding code.

### CI

The GitHub Actions CI workflow for this repo is generated by [`haskell-ci`](https://github.com/haskell-CI/haskell-ci):

```shell
haskell-ci regenerate
```
