{-# LANGUAGE ForeignFunctionInterface #-}
module Numeric.CBLAS.FFI.Private (
   Routine.dotu, Routine.dotc, Routine.sum,
   copyMatrix,
   copym,
   Routine.addMatrix,
   Trans, UpLo, Diag,
   DOff, Dim, Inc,
   noTranspose, transpose, conjNoTranspose, conjTranspose,
   lower, upper, dense,
   nonUnitDiag, unitDiag,
   ) where

import qualified Numeric.CBLAS.FFI.Routine as Routine
import Numeric.CBLAS.FFI.Type

import qualified Numeric.Netlib.Modifier as Modi
import qualified Numeric.Netlib.Class as Class

import Foreign.Ptr (Ptr)

import Data.Complex (Complex)



{-
void bli_scopym
     (
       doff_t   diagoffa,
       diag_t   diaga,
       uplo_t   uploa,
       trans_t  transa,
       dim_t    m,
       dim_t    n,
       ctype*   a, inc_t rsa, inc_t csa,
       ctype*   b, inc_t rsb, inc_t csb
     );
-}

type CopyM a =
      DOff ->
      Diag ->
      UpLo ->
      Trans ->
      Dim -> Dim ->
      Ptr a -> Inc -> Inc ->
      Ptr a -> Inc -> Inc ->
      IO ()

foreign import ccall "bli_scopym" scopym :: CopyM Float
foreign import ccall "bli_dcopym" dcopym :: CopyM Double
foreign import ccall "bli_ccopym" ccopym :: CopyM (Complex Float)
foreign import ccall "bli_zcopym" zcopym :: CopyM (Complex Double)

newtype CopyM_ a = CopyM_ {getCopyM :: CopyM a}

copym :: (Class.Floating a) => CopyM a
copym =
   getCopyM $
   Class.switchFloating
      (CopyM_ scopym) (CopyM_ dcopym) (CopyM_ ccopym) (CopyM_ zcopym)


copyMatrix ::
   (Class.Floating a) =>
   Modi.Transposition ->
   Int -> Int ->
   Ptr a -> Int ->
   Ptr a -> Int ->
   IO ()
copyMatrix transp rows cols a lda b ldb =
   let (m,n,trans) =
        case transp of
           Modi.Transposed -> (cols, rows, transpose)
           Modi.NonTransposed -> (rows, cols, noTranspose) in
   copym
      0 nonUnitDiag dense trans
      (fromIntegral m) (fromIntegral n)
      a 1 (fromIntegral lda)
      b 1 (fromIntegral ldb)
