module Numeric.CBLAS.FFI.Type where

import Data.Int
import Data.Word


#include <blis.h>


type CBlasInt = F77Int


type F77Int = #{type f77_int}


type Trans = #{type trans_t}
type UpLo  = #{type uplo_t}
type Diag  = #{type diag_t}

type DOff  = #{type doff_t}
type Dim   = #{type dim_t}
type Inc   = #{type inc_t}


noTranspose, transpose, conjNoTranspose, conjTranspose :: Trans
noTranspose     = #{const BLIS_NO_TRANSPOSE}
transpose       = #{const BLIS_TRANSPOSE}
conjNoTranspose = #{const BLIS_CONJ_NO_TRANSPOSE}
conjTranspose   = #{const BLIS_CONJ_TRANSPOSE}

lower, upper, dense :: UpLo
lower = #{const BLIS_LOWER}
upper = #{const BLIS_UPPER}
dense = #{const BLIS_DENSE}

nonUnitDiag, unitDiag :: Diag
nonUnitDiag = #{const BLIS_NONUNIT_DIAG}
unitDiag    = #{const BLIS_UNIT_DIAG}
