#include <mkl_trans.h>
#include <stddef.h>
#include <complex.h>

void mkl_comatcopy_hs(
    char ordering, char trans,
    size_t rows, size_t cols,
    const float alphaR, const float alphaI,
    const MKL_Complex8 * A, size_t lda,
    MKL_Complex8 * B, size_t ldb)
{
    MKL_Complex8 alpha = {alphaR, alphaI};
    mkl_comatcopy(
        ordering, trans,
        rows, cols,
        alpha, // MKL_Complex8 {alphaR, alphaI},
        A, lda,
        B, ldb);
}

void mkl_zomatcopy_hs(
    char ordering, char trans,
    size_t rows, size_t cols,
    const double alphaR, const double alphaI,
    const MKL_Complex16 * A, size_t lda,
    MKL_Complex16 * B, size_t ldb)
{
    MKL_Complex16 alpha = {alphaR, alphaI};
    mkl_zomatcopy(
        ordering, trans,
        rows, cols,
        alpha, // CMPLX(alphaR,alphaI),
        A, lda,
        B, ldb);
}


void mkl_comatadd_hs(
    char ordering, char transa, char transb,
    size_t rows, size_t cols,
    const float alphaR, const float alphaI,
    const MKL_Complex8 * A, size_t lda,
    const float betaR, const float betaI,
    const MKL_Complex8 * B, size_t ldb,
    MKL_Complex8 * C, size_t ldc)
{
    MKL_Complex8 alpha = {alphaR, alphaI};
    MKL_Complex8 beta = {betaR, betaI};
    mkl_comatadd(
        ordering, transa, transb,
        rows, cols,
        alpha,
        A, lda,
        beta,
        B, ldb,
        C, ldc);
}

void mkl_zomatadd_hs(
    char ordering, char transa, char transb,
    size_t rows, size_t cols,
    const double alphaR, const double alphaI,
    const MKL_Complex16 * A, size_t lda,
    const double betaR, const double betaI,
    const MKL_Complex16 * B, size_t ldb,
    MKL_Complex16 * C, size_t ldc)
{
    MKL_Complex16 alpha = {alphaR, alphaI};
    MKL_Complex16 beta = {betaR, betaI};
    mkl_zomatadd(
        ordering, transa, transb,
        rows, cols,
        alpha,
        A, lda,
        beta,
        B, ldb,
        C, ldc);
}
