module Numeric.CBLAS.FFI.Type where

import Data.Int
import Data.Word


#include <cblas.h>



type CBlasInt = BlasInt


type BlasInt = #{type blasint}



newtype Order = Order #{type CBLAS_ORDER}
   deriving (Eq)

#{enum Order, Order
   , rowMajor = CblasRowMajor
   , columnMajor = CblasColMajor
   }


newtype Transpose = Transpose #{type CBLAS_TRANSPOSE}
   deriving (Eq)

#{enum Transpose, Transpose
   , noTrans = CblasNoTrans
   , trans = CblasTrans
   , conjTrans = CblasConjTrans
   , conjNoTrans = CblasConjNoTrans
   }
