--
-- Copyright (c) 2013-2025 Nicola Bonelli <nicola@larthia.com>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
{-# LANGUAGE DeriveLift #-}

module CGrep.FileKind (
    FileKind (..),
)
where

import Language.Haskell.TH.Syntax (Lift)

data FileKind = KindText | KindConfig | KindLanguage | KindData | KindMarkup | KindScript
    deriving stock (Eq, Ord, Enum, Bounded, Lift)

instance Show FileKind where
    show KindText = "Text"
    show KindConfig = "Config"
    show KindLanguage = "Language"
    show KindData = "Data"
    show KindMarkup = "Markup"
    show KindScript = "Script"

instance Read FileKind where
    readsPrec _ "Text" = [(KindText, "")]
    readsPrec _ "Config" = [(KindConfig, "")]
    readsPrec _ "Language" = [(KindLanguage, "")]
    readsPrec _ "Data" = [(KindData, "")]
    readsPrec _ "Markup" = [(KindMarkup, "")]
    readsPrec _ "Script" = [(KindScript, "")]
    readsPrec _ _ = []
