/*
 * Decompiled with CFR 0.152.
 */
package org.clafer.ig;

import edu.mit.csail.sdg.alloy4.A4Reporter;
import edu.mit.csail.sdg.alloy4.Err;
import edu.mit.csail.sdg.alloy4.ErrorSyntax;
import edu.mit.csail.sdg.alloy4.ErrorWarning;
import edu.mit.csail.sdg.alloy4.Pos;
import edu.mit.csail.sdg.alloy4.SafeList;
import edu.mit.csail.sdg.alloy4compiler.ast.Command;
import edu.mit.csail.sdg.alloy4compiler.ast.CommandScope;
import edu.mit.csail.sdg.alloy4compiler.ast.Sig;
import edu.mit.csail.sdg.alloy4compiler.parser.AlloyCompiler;
import edu.mit.csail.sdg.alloy4compiler.parser.CompModule;
import edu.mit.csail.sdg.alloy4compiler.translator.A4Options;
import edu.mit.csail.sdg.alloy4compiler.translator.A4Solution;
import edu.mit.csail.sdg.alloy4compiler.translator.TranslateAlloyToKodkod;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.clafer.ig.AlloyIGException;
import org.clafer.ig.Util;

public final class AlloyIG {
    private static Operation nextOperation() throws IOException {
        String string = Util.readMessage();
        if (string == null || string.equals("quit")) {
            return new QuitOperation();
        }
        if (string.equals("load")) {
            String string2 = Util.readMessage();
            return new LoadOperation(string2);
        }
        if (string.equals("next")) {
            return new NextOperation();
        }
        if (string.equals("setGlobalScope")) {
            int n = Util.readIntMessage();
            return new SetGlobalScopeOperation(n);
        }
        if (string.equals("setScope")) {
            String string3 = Util.readMessage();
            int n = Util.readIntMessage();
            return new SetScopeOperation(string3, n);
        }
        if (string.equals("resolve")) {
            return new ResolveOperation();
        }
        if (string.equals("saveState")) {
            return new SaveStateOperation();
        }
        if (string.equals("restoreState")) {
            return new RestoreStateOperation();
        }
        if (string.equals("removeConstraint")) {
            return new RemoveConstraintOperation(Util.readIntMessage(), Util.readIntMessage(), Util.readIntMessage(), Util.readIntMessage() - 1);
        }
        if (string.equals("unsatCore")) {
            return new UnsatCoreOperation();
        }
        if (string.equals("unsatCoreMinimization")) {
            int n = Util.readIntMessage();
            return new SetUnsatCoreMinimizationOperation(n);
        }
        if (string.equals("setBitwidth")) {
            int n = Util.readIntMessage();
            return new SetBitwidthOperation(n);
        }
        throw new AlloyIGException("Unknown op " + string);
    }

    private static CommandScope setCommandScopeSize(int n, CommandScope commandScope) throws ErrorSyntax {
        return new CommandScope(commandScope.pos, commandScope.sig, commandScope.isExact, n, n, commandScope.increment);
    }

    private static List<CommandScope> setScopeSize(Sig sig, int n, List<CommandScope> list) throws ErrorSyntax {
        ArrayList<CommandScope> arrayList = new ArrayList<CommandScope>();
        boolean bl = false;
        for (CommandScope commandScope : list) {
            if (sig.equals((Object)commandScope.sig)) {
                bl = true;
                arrayList.add(AlloyIG.setCommandScopeSize(n, commandScope));
                continue;
            }
            arrayList.add(commandScope);
        }
        if (!bl) {
            arrayList.add(new CommandScope(sig, false, n));
        }
        return arrayList;
    }

    private static String toXml(A4Solution a4Solution) throws Err, IOException {
        StringWriter stringWriter = new StringWriter();
        a4Solution.writeXML(new PrintWriter(stringWriter), null, null);
        return stringWriter.toString();
    }

    private static String multiplicity(Sig sig) {
        if (sig.isOne != null) {
            return "One";
        }
        if (sig.isLone != null) {
            return "Lone";
        }
        if (sig.isSome != null) {
            return "Some";
        }
        return "Any";
    }

    public static void main(String[] stringArray) throws IOException, Err {
        try {
            System.loadLibrary("minisatprover");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.loadLibrary("minisatproverx1");
        }
        try {
            AlloyIG.run(stringArray);
        }
        catch (EOFException eOFException) {
            System.err.println("AlloyIG stream closed.");
        }
    }

    private static String removeCurly(String string) {
        int n = string.length();
        if (n > 0 && string.charAt(0) == '{' && string.charAt(n - 1) == '}') {
            return string.substring(1, n - 1);
        }
        throw new IllegalArgumentException("\"" + string + "\" is not surrounded by curly brackets.");
    }

    public static void run(String[] stringArray) throws IOException, Err {
        block19: {
            AlloyIGReporter alloyIGReporter = new AlloyIGReporter();
            CompModule compModule = null;
            SafeList safeList = null;
            Command command = null;
            Object object = null;
            Operation operation = null;
            A4Options a4Options = new A4Options();
            a4Options.coreMinimization = 2;
            a4Options.solver = A4Options.SatSolver.MiniSatProverJNI;
            Util.State<StateExtra> state = null;
            block0: while (true) {
                Pos pos;
                Sig sig;
                Object object2;
                if ((operation = AlloyIG.nextOperation()) instanceof LoadOperation) {
                    object2 = (LoadOperation)operation;
                    compModule = AlloyCompiler.parse(alloyIGReporter, ((LoadOperation)object2).getModel());
                    safeList = compModule.getAllSigs();
                    command = (Command)compModule.getAllCommands().get(0);
                    Util.writeMessage(Integer.toString(safeList.size()));
                    for (Sig sig2 : safeList) {
                        Util.writeMessage(sig2.label);
                        Util.writeMessage(AlloyIG.multiplicity(sig2));
                        Util.writeMessage(sig2 instanceof Sig.PrimSig ? "" : AlloyIG.removeCurly(sig2.type().toString()));
                        sig = command.getScope(sig2);
                        if (sig == null) {
                            Util.writeMessage("False");
                            continue;
                        }
                        Util.writeMessage("True");
                        Util.writeMessage(sig.startingScope);
                    }
                    Util.writeMessage(Integer.toString(command.overall));
                    continue;
                }
                if (operation instanceof ResolveOperation) {
                    alloyIGReporter.minimizedBefore = 0;
                    alloyIGReporter.minimizedAfter = 0;
                    object = TranslateAlloyToKodkod.execute_command((A4Reporter)alloyIGReporter, (Iterable)compModule.getAllReachableSigs(), (Command)command, (A4Options)a4Options);
                    continue;
                }
                if (operation instanceof NextOperation) {
                    if (object.satisfiable()) {
                        Util.writeMessage("True");
                        Util.writeMessage(AlloyIG.toXml(object));
                        object2 = object.next();
                        if (object2 != object) {
                            object = object2;
                            continue;
                        }
                        break block19;
                    }
                    Util.writeMessage("False");
                    continue;
                }
                if (operation instanceof SetGlobalScopeOperation) {
                    object2 = (SetGlobalScopeOperation)operation;
                    int n = ((SetGlobalScopeOperation)object2).getScopeSize();
                    Command command2 = command;
                    command = new Command(command2.pos, command2.label, command2.check, n, command2.bitwidth, command2.maxseq, command2.expects, (Iterable)command2.scope, (Iterable)command2.additionalExactScopes, command2.formula, command2.parent);
                    continue;
                }
                if (operation instanceof SetScopeOperation) {
                    object2 = (SetScopeOperation)operation;
                    pos = ((SetScopeOperation)object2).getSig();
                    int n = ((SetScopeOperation)object2).getScopeSize();
                    sig = Util.findSig((String)pos, (Iterable<Sig>)safeList);
                    List<CommandScope> list = AlloyIG.setScopeSize(sig, n, (List<CommandScope>)command.scope);
                    Command command3 = command;
                    command = new Command(command3.pos, command3.label, command3.check, command3.overall, command3.bitwidth, command3.maxseq, command3.expects, list, (Iterable)command3.additionalExactScopes, command3.formula, command3.parent);
                    continue;
                }
                if (operation instanceof SaveStateOperation) {
                    state = Util.saveState((SafeList<Sig>)safeList, new StateExtra(alloyIGReporter.minimizedBefore, alloyIGReporter.minimizedAfter, (A4Solution)object, command));
                    continue;
                }
                if (operation instanceof RestoreStateOperation) {
                    object2 = (StateExtra)Util.restoreState(state, (SafeList<Sig>)safeList);
                    alloyIGReporter.minimizedBefore = ((StateExtra)object2).getMinimizedBefore();
                    alloyIGReporter.minimizedAfter = ((StateExtra)object2).getMinimizedAfter();
                    object = ((StateExtra)object2).getAnswer();
                    command = ((StateExtra)object2).getCommand();
                    continue;
                }
                if (operation instanceof RemoveConstraintOperation) {
                    object2 = (RemoveConstraintOperation)operation;
                    pos = ((RemoveConstraintOperation)object2).getPos();
                    Command command4 = Util.removeGlobalConstraint(pos, command);
                    if (command4 == null) {
                        if (Util.removeLocalConstraint(pos, (Iterable<Sig>)safeList)) continue;
                        throw new AlloyIGException(String.format("Cannot remove constraint (line=%d, column=%d)-(line=%d, column=%d)", pos.y, pos.x, pos.y2, pos.x2));
                    }
                    command = command4;
                    continue;
                }
                if (operation instanceof UnsatCoreOperation) {
                    if (alloyIGReporter.minimizedAfter > 0) {
                        object2 = (Set)object.highLevelCore().a;
                        Util.writeMessage(object2.size());
                        pos = object2.iterator();
                        while (true) {
                            if (!pos.hasNext()) continue block0;
                            Pos pos2 = (Pos)pos.next();
                            Util.writeMessage(pos2.y);
                            Util.writeMessage(pos2.x);
                            Util.writeMessage(pos2.y2);
                            Util.writeMessage(pos2.x2 + 1);
                        }
                    }
                    Util.writeMessage(0);
                    continue;
                }
                if (operation instanceof SetUnsatCoreMinimizationOperation) {
                    object2 = (SetUnsatCoreMinimizationOperation)operation;
                    a4Options.coreMinimization = ((SetUnsatCoreMinimizationOperation)object2).getMinimizationLevel();
                    continue;
                }
                if (!(operation instanceof SetBitwidthOperation)) break;
                object2 = (SetBitwidthOperation)operation;
                pos = command;
                command = new Command(pos.pos, pos.label, pos.check, pos.overall, ((SetBitwidthOperation)object2).getBitwidth(), pos.maxseq, pos.expects, (Iterable)pos.scope, (Iterable)pos.additionalExactScopes, pos.formula, pos.parent);
            }
            if (!(operation instanceof QuitOperation)) {
                throw new IllegalStateException("Unknown operation " + operation);
            }
        }
    }

    private static class StateExtra {
        private final int minimizedBefore;
        private final int minimizedAfter;
        private final A4Solution answer;
        private final Command command;

        public StateExtra(int n, int n2, A4Solution a4Solution, Command command) {
            this.minimizedBefore = n;
            this.minimizedAfter = n2;
            this.answer = Util.notNull(a4Solution);
            this.command = Util.notNull(command);
        }

        public int getMinimizedBefore() {
            return this.minimizedBefore;
        }

        public int getMinimizedAfter() {
            return this.minimizedAfter;
        }

        public A4Solution getAnswer() {
            return this.answer;
        }

        public Command getCommand() {
            return this.command;
        }
    }

    private static class SetBitwidthOperation
    implements Operation {
        private final int bitwidth;

        public SetBitwidthOperation(int n) {
            if (n < 1) {
                throw new IllegalArgumentException(n + " is an invalid bitwidth.");
            }
            this.bitwidth = n;
        }

        public int getBitwidth() {
            return this.bitwidth;
        }
    }

    private static class SetUnsatCoreMinimizationOperation
    implements Operation {
        private final int minimizationLevel;

        public SetUnsatCoreMinimizationOperation(int n) {
            if (n < 0 || n > 2) {
                throw new IllegalArgumentException(n + " is in invalid optimization level.");
            }
            this.minimizationLevel = n;
        }

        public int getMinimizationLevel() {
            return this.minimizationLevel;
        }
    }

    private static class SetScopeOperation
    implements Operation {
        private final String sig;
        private final int scopeSize;

        public SetScopeOperation(String string, int n) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.sig = string;
            this.scopeSize = n;
        }

        public String getSig() {
            return this.sig;
        }

        public int getScopeSize() {
            return this.scopeSize;
        }
    }

    private static class SetGlobalScopeOperation
    implements Operation {
        private final int scopeSize;

        public SetGlobalScopeOperation(int n) {
            this.scopeSize = n;
        }

        public int getScopeSize() {
            return this.scopeSize;
        }
    }

    private static class QuitOperation
    implements Operation {
        private QuitOperation() {
        }
    }

    private static class UnsatCoreOperation
    implements Operation {
        private UnsatCoreOperation() {
        }
    }

    private static class RemoveConstraintOperation
    implements Operation {
        private final int y;
        private final int x;
        private final int y2;
        private final int x2;

        public RemoveConstraintOperation(int n, int n2, int n3, int n4) {
            this.y = n;
            this.x = n2;
            this.y2 = n3;
            this.x2 = n4;
        }

        public Pos getPos() {
            return new Pos("", this.x, this.y, this.x2, this.y2);
        }
    }

    private static class RestoreStateOperation
    implements Operation {
        private RestoreStateOperation() {
        }
    }

    private static class SaveStateOperation
    implements Operation {
        private SaveStateOperation() {
        }
    }

    private static class NextOperation
    implements Operation {
        private NextOperation() {
        }
    }

    private static class ResolveOperation
    implements Operation {
        private ResolveOperation() {
        }
    }

    private static class LoadOperation
    implements Operation {
        private final String model;

        public LoadOperation(String string) {
            this.model = string;
        }

        public String getModel() {
            return this.model;
        }
    }

    private static interface Operation {
    }

    private static class AlloyIGReporter
    extends A4Reporter {
        private int minimizedBefore;
        private int minimizedAfter;

        private AlloyIGReporter() {
        }

        public void warning(ErrorWarning errorWarning) {
            System.err.print("Relevance Warning:\n" + errorWarning.toString().trim() + "\n\n");
            System.err.flush();
        }

        public void minimized(Object object, int n, int n2) {
            this.minimizedBefore = n;
            this.minimizedAfter = n2;
            super.minimized(object, n, n2);
        }
    }
}

