/*
 * Decompiled with CFR 0.152.
 */
package org.clafer.ig;

import edu.mit.csail.sdg.alloy4.Pos;
import edu.mit.csail.sdg.alloy4.SafeList;
import edu.mit.csail.sdg.alloy4compiler.ast.Command;
import edu.mit.csail.sdg.alloy4compiler.ast.Expr;
import edu.mit.csail.sdg.alloy4compiler.ast.ExprLet;
import edu.mit.csail.sdg.alloy4compiler.ast.ExprList;
import edu.mit.csail.sdg.alloy4compiler.ast.ExprUnary;
import edu.mit.csail.sdg.alloy4compiler.ast.ExprVar;
import edu.mit.csail.sdg.alloy4compiler.ast.Sig;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.clafer.ig.AlloyIGException;

public class Util {
    private static final BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
    private static final PrintStream output = System.out;
    private static final Field isOne;
    private static final Field isLone;
    private static final Field isSome;
    private static final Field facts;

    private static void set(Sig sig, Field field, Object object) {
        try {
            field.set(sig, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlloyIGException(illegalAccessException);
        }
    }

    public static <T> T notNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static <T> State<T> saveState(SafeList<Sig> safeList, T t) {
        SafeList[] safeListArray = new SafeList[safeList.size()];
        Pos[] posArray = new Pos[safeList.size()];
        Pos[] posArray2 = new Pos[safeList.size()];
        Pos[] posArray3 = new Pos[safeList.size()];
        for (int i = 0; i < safeListArray.length; ++i) {
            Sig sig = (Sig)safeList.get(i);
            safeListArray[i] = sig.getFacts();
            posArray[i] = sig.isOne;
            posArray2[i] = sig.isLone;
            posArray3[i] = sig.isSome;
        }
        return new State<T>(safeListArray, posArray, posArray2, posArray3, t);
    }

    public static <T> T restoreState(State<T> state, SafeList<Sig> safeList) {
        for (int i = 0; i < ((State)state).save.length; ++i) {
            Sig sig = (Sig)safeList.get(i);
            Util.set(sig, facts, ((State)state).save[i]);
            Util.set(sig, isOne, ((State)state).isOnes[i]);
            Util.set(sig, isLone, ((State)state).isLones[i]);
            Util.set(sig, isSome, ((State)state).isSomes[i]);
        }
        return (T)((State)state).extra;
    }

    public static int readIntMessage() throws IOException {
        return Integer.parseInt(Util.readMessage());
    }

    public static String readMessage() throws IOException {
        int n;
        String string = input.readLine();
        if (string == null) {
            throw new EOFException();
        }
        int n2 = Integer.parseInt(string);
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; i += n) {
            n = input.read(cArray, i, n2 - i);
            if (n != -1) continue;
            throw new EOFException();
        }
        return new String(cArray);
    }

    public static void writeMessage(int n) throws IOException {
        Util.writeMessage(Integer.toString(n));
    }

    public static void writeMessage(String string) throws IOException {
        output.println(string.length());
        output.print(string);
    }

    public static Sig findSig(String string, Iterable<Sig> iterable) {
        for (Sig sig : iterable) {
            if (!string.equals(sig.label)) continue;
            return sig;
        }
        throw new AlloyIGException("Unknown sig " + string);
    }

    public static Command removeGlobalConstraint(Pos pos, Command command) {
        Expr expr = Util.removeSubnode(pos, command.formula);
        if (Util.notNull(expr) == command.formula) {
            return null;
        }
        return new Command(command.pos, command.label, command.check, command.overall, command.bitwidth, command.maxseq, command.expects, (Iterable)command.scope, (Iterable)command.additionalExactScopes, expr, command.parent);
    }

    private static <T> List<T> asList(Iterable<T> iterable) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : iterable) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public static boolean removeLocalConstraint(Pos pos, Iterable<Sig> iterable) {
        for (Sig sig : iterable) {
            if (pos.equals((Object)sig.isOne)) {
                Util.set(sig, isOne, null);
                return true;
            }
            if (pos.equals((Object)sig.isLone)) {
                Util.set(sig, isLone, null);
                return true;
            }
            if (pos.equals((Object)sig.isSome)) {
                Util.set(sig, isSome, null);
                return true;
            }
            ArrayList arrayList = new ArrayList(Util.asList(sig.getFacts()));
            ListIterator<Expr> listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                Expr expr = (Expr)listIterator.next();
                Expr expr2 = Util.removeSubnode(pos, expr);
                if (expr2 == null) {
                    listIterator.remove();
                    Util.set(sig, facts, new SafeList(arrayList));
                    return true;
                }
                if (expr2 == expr) continue;
                listIterator.set(expr2);
                Util.set(sig, facts, new SafeList(arrayList));
                return true;
            }
        }
        return false;
    }

    private static Expr removeSubnode(Pos pos, Expr expr) {
        if (pos.equals((Object)expr.span())) {
            return null;
        }
        if (expr instanceof ExprList) {
            ExprList exprList = (ExprList)expr;
            ArrayList arrayList = new ArrayList(exprList.args);
            ListIterator<Expr> listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                Expr expr2 = (Expr)listIterator.next();
                Expr expr3 = Util.removeSubnode(pos, expr2);
                if (expr3 == null) {
                    listIterator.remove();
                    return ExprList.make((Pos)exprList.pos, (Pos)exprList.closingBracket, (ExprList.Op)exprList.op, arrayList);
                }
                if (expr3 == expr2) continue;
                listIterator.set(expr3);
                return ExprList.make((Pos)exprList.pos, (Pos)exprList.closingBracket, (ExprList.Op)exprList.op, arrayList);
            }
        } else if (expr instanceof ExprUnary) {
            ExprUnary exprUnary = (ExprUnary)expr;
            ExprUnary.Op op = exprUnary.op;
            Expr expr4 = exprUnary.sub;
            Expr expr5 = Util.removeSubnode(pos, expr4);
            if (expr5 == null) {
                return null;
            }
            if (expr5 != expr4) {
                return op.make(exprUnary.pos, expr5);
            }
        } else if (expr instanceof ExprLet) {
            ExprLet exprLet = (ExprLet)expr;
            Expr expr6 = Util.removeSubnode(pos, exprLet.sub);
            if (expr6 == null) {
                return null;
            }
            if (expr6 != exprLet.sub) {
                ExprLet.make((Pos)exprLet.pos, (ExprVar)exprLet.var, (Expr)exprLet.expr, (Expr)expr6);
            }
        }
        return expr;
    }

    static {
        try {
            isOne = Sig.class.getDeclaredField("isOne");
            isLone = Sig.class.getDeclaredField("isLone");
            isSome = Sig.class.getDeclaredField("isSome");
            facts = Sig.class.getDeclaredField("facts");
            isOne.setAccessible(true);
            isLone.setAccessible(true);
            isSome.setAccessible(true);
            facts.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AlloyIGException(noSuchFieldException);
        }
    }

    public static class State<T> {
        private final SafeList<Expr>[] save;
        private final Pos[] isOnes;
        private final Pos[] isLones;
        private final Pos[] isSomes;
        private final T extra;

        public State(SafeList<Expr>[] safeListArray, Pos[] posArray, Pos[] posArray2, Pos[] posArray3, T t) {
            this.save = safeListArray;
            this.isOnes = posArray;
            this.isLones = posArray2;
            this.isSomes = posArray3;
            this.extra = t;
        }
    }
}

