-- |
-- Module      : Application.CLI.Class
-- License     : BSD-Style
-- Copyright   : Copyright © 2014 Nicolas DI PRIMA
--
-- Maintainer  : Nicolas DI PRIMA <nicolas@di-prima.fr>
-- Stability   : experimental
-- Portability : unknown
--
module Application.CLI.Class
    ( CLI (..)
    , cliToCommand
    ) where

import Application.CLI.Types

class CLI cli where
    name    :: cli
            -> String
    desc    :: cli
            -> String
    options :: cli
            -> [OptHelp]
    action  :: cli
            -> CLIContext
            -> [String]
            -> IO ()

cliToCommand :: CLI cli
             => cli
             -> Command
cliToCommand cli =
    Command
        { cmdName    = name cli
        , cmdDesc    = desc cli
        , cmdOptions = options cli
        , cmdAction  = action cli
        }
