module Distribution.CommandLine
    ( writeManpages
    , writeBashCompletions
    , setManpath
    ) where

import           Control.Monad      (unless, void)
import           System.Directory   (createDirectoryIfMissing)
import           System.Environment (lookupEnv)
import           System.Process     (readCreateProcessWithExitCode, shell)

setManpath :: IO ()
setManpath = do
    home <- lookupEnv "HOME"
    case home of
        Just x -> do
            let bashRc = x ++ "/.bashrc"
            config <- readFile bashRc
            unless ("#manpath updated by cli-setup" `elem` lines config)
                (appendFile bashRc "\n#manpath updated by cli-setup\nexport MANPATH=~/.local/share:$MANPATH\n" >>
                 void (readCreateProcessWithExitCode (shell $ "MANPATH=" ++ x ++ "/.local/share mandb") ""))
        Nothing -> pure ()

writeManpages :: FilePath -- ^ Source File
              -> FilePath -- ^ Manpage file name
              -> IO ()
writeManpages p p' = do
    home <- lookupEnv "HOME"
    case home of
        Just x -> do
            let manPath = x ++ "/.local/share/man/man1"
            createDirectoryIfMissing True manPath
            writeFile (manPath ++ "/" ++ p') =<< readFile p
        Nothing -> pure ()

writeBashCompletions :: String -- ^ Executable name
                     -> IO ()
writeBashCompletions exeName = do
    home <- lookupEnv "HOME"
    case home of
        Just x -> do
            let bashRc = x ++ "/.bashrc"
            config <- readFile bashRc
            unless (("# Added for " ++ exeName) `elem` lines config)
                (appendFile bashRc ("\n# Added for " ++ exeName ++ "\neval \"$(" ++ exeName ++ " --bash-completion-script " ++ exeName ++ ")\"\n"))
        Nothing -> pure ()
