-- Binary file signatures (magic bytes) for file type detection

let Signature = { name : Text, bytes : List Natural }

let signatures : List Signature =
    [ -- Images
      { name = "JPEG", bytes = [0xFF, 0xD8, 0xFF] }
    , { name = "PNG", bytes = [0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A] }
    , { name = "GIF", bytes = [0x47, 0x49, 0x46, 0x38] }
    , { name = "ICO", bytes = [0x00, 0x00, 0x01, 0x00] }
    
      -- Documents
    , { name = "PDF", bytes = [0x25, 0x50, 0x44, 0x46] }
    , { name = "MS Office", bytes = [0xD0, 0xCF, 0x11, 0xE0] }
    , { name = "MS Office 2007+", bytes = [0x50, 0x4B, 0x03, 0x04, 0x14, 0x00] }
    
      -- Archives
    , { name = "ZIP/JAR/EPUB", bytes = [0x50, 0x4B, 0x03, 0x04] }
    , { name = "GZIP", bytes = [0x1F, 0x8B, 0x08] }
    , { name = "BZIP2", bytes = [0x42, 0x5A, 0x68] }
    , { name = "7Z", bytes = [0x37, 0x7A, 0xBC, 0xAF, 0x27, 0x1C] }
    , { name = "RAR", bytes = [0x52, 0x61, 0x72, 0x21, 0x1A, 0x07] }
    , { name = "Compress", bytes = [0x1F, 0x43, 0x4F, 0x4D] }
    
      -- Executables
    , { name = "Windows EXE", bytes = [0x4D, 0x5A] }
    , { name = "ELF (Linux/Unix)", bytes = [0x7F, 0x45, 0x4C, 0x46] }
    , { name = "Java class", bytes = [0xCA, 0xFE, 0xBA, 0xBE] }
    , { name = "WebAssembly", bytes = [0x00, 0x61, 0x73, 0x6D] }
    
      -- Media
    , { name = "FLV", bytes = [0x46, 0x4C, 0x56, 0x01] }
    , { name = "MP3 with ID3", bytes = [0x49, 0x44, 0x33] }
    , { name = "MP3 without ID3", bytes = [0xFF, 0xFB] }
    , { name = "OGG", bytes = [0x4F, 0x67, 0x67, 0x53] }
    , { name = "WEBM", bytes = [0x1A, 0x45, 0xDF, 0xA3] }
    , { name = "MP4", bytes = [0x00, 0x00, 0x00, 0x14, 0x66, 0x74, 0x79, 0x70] }
    ]

in { signatures = signatures }