module Main
  ( main
  )
  where

import Colog.Monad (usingLoggerT)
import Colog.Simple (LogAction, Message, Severity (Debug, Notice), basicFmt,
  colorFmt, colorSevFmt, logger, logInfo, logNotice, logTest, logTextStderr,
  logTextStdout)


main :: IO ()
main = do
  usingLoggerT (logger colorSevFmt logTextStdout Debug) $ do
    logNotice "Examples of all Severity values\n"
    logTest

  usingLoggerT (logger colorFmt logTextStderr Notice) $ do
    logNotice "\nExample of a different formatter with Severity set to Notice"
    logNotice "These are going to stderr\n"
    logTest

  usingLoggerT (logger basicFmt logTextStdout Debug) $ do
    logNotice "\nNo colors is possible of course\n"
    logTest

  -- Example of completely turning off logging
  usingLoggerT (mempty :: LogAction IO Message) $
    logInfo "This message should never be shown"
