module Main
  ( main
  )
  where

import Colog.Monad (usingLoggerT)
import Colog.Simple (LogAction, Message, Severity (Debug, Notice), (%), (%+),
  logger, logInfo, logNotice, logTest, logTextStderr, logTextStdout, msg, msgc,
  sevc, stack)


main :: IO ()
main = do
  putStrLn "------------------------------------------"
  usingLoggerT (logger (sevc % msg) logTextStdout Debug) $ do
    logNotice "Examples of all Severity values"
    logTest

  putStrLn "------------------------------------------"
  usingLoggerT (logger msgc logTextStderr Notice) $ do
    logNotice "Example of a different formatter with Severity set to Notice"
    logNotice "These are going to stderr"
    logTest

  putStrLn "------------------------------------------"
  usingLoggerT (logger msg logTextStdout Debug) $ do
    logNotice "No colors is possible of course"
    logTest

  putStrLn "------------------------------------------"
  usingLoggerT (logger (sevc % msg %+ stack) logTextStdout Debug) $ do
    logNotice "With call stack info"
    logTest

  putStrLn "------------------------------------------"
  -- Example of completely turning off logging
  usingLoggerT (mempty :: LogAction IO Message) $
    logInfo "This message should never be shown"
