{-|
Custom severity type very much like the one in co-log-core but with an added
severity of 'Notice' between 'Info' and 'Warning'

The motivation is sometimes more- or less-chatty "normal" messages are useful
that can be filtered by a verbosity setting. This is distinct from debugging or
logging warnings/errors.

The code in this library is parameterized with this Severity type, not the
"stock" one in co-log/co-log-core.
-}
module Colog.Simple.Severity
  (
    -- * Types
    Severity (..)
  )
  where

import Data.Ix (Ix)


-- | A custom severity type that includes an additional 'Notice' severity
--   between 'Info' and 'Warning'
data Severity = Debug | Info | Notice | Warning | Error
  deriving (Bounded, Enum, Eq, Ix, Ord, Read, Show)
