{-# LANGUAGE UndecidableInstances #-}
module Internal.Data.Basic.Compare where

import Internal.Interlude

import Internal.Data.Basic.Types
import Internal.Data.Basic.Sql.Types

class ComparableInDbExp (a :: *) (b :: *) where
    compareInDbExp :: Comparison -> a -> b -> ConditionExp
instance {-# INCOHERENT #-} (ValueAsDbExp b a, Ord a)
    => ComparableInDbExp (DbExp k a) b where
    compareInDbExp comp a b = Compare comp a (valueAsDbExp b)
instance {-# INCOHERENT #-} (ValueAsDbExp a b, Ord b)
    => ComparableInDbExp a (DbExp k b) where
    compareInDbExp comp a = Compare comp (valueAsDbExp a)

infix 4 ==.
infix 4 >.
infix 4 /=.
infix 4 <.
infix 4 <=.
infix 4 >=.
infix 3 &&.
infix 2 ||.

(>.), (==.), (/=.), (<.), (<=.), (>=.) :: ComparableInDbExp a b => a -> b -> ConditionExp
(>.) = compareInDbExp GreaterThan
(==.) = compareInDbExp Equal
(/=.) = compareInDbExp NotEqual
(<.) = compareInDbExp LessThan
(<=.) = compareInDbExp LessOrEqual
(>=.) = compareInDbExp GreaterOrEqual

(&&.) :: ConditionExp -> ConditionExp -> ConditionExp
(&&.) = BoolOp And

(||.) :: ConditionExp -> ConditionExp -> ConditionExp
(||.) = BoolOp Or
