{-# LANGUAGE DataKinds, NoImplicitPrelude, TypeFamilies, FlexibleInstances #-}
{-# LANGUAGE MultiParamTypeClasses, FlexibleContexts, OverloadedStrings #-}
import Prelude hiding (id)

import Data.Time
import System.Mem
import Database.PostgreSQL.Simple

import Data.Basic
import Control.Monad.IO.Class
import Control.Lens
import Control.Monad
import Data.Function ((&))


import Control.Concurrent
import Model

insertNewSession :: MonadIO m => Connection -> LocalTime -> m ()
insertNewSession conn expiration =
    handleBasicPsql conn query'
    where
        session = newUserSession
            & expirationDate .~ expiration
            & id .~ 0
        query'  = void $ insert session

main :: IO ()
main = do
    conn <- connectPostgreSQL "host=localhost port=5432 user=postgres dbname=postgres password=admin connect_timeout=10"
    t <- do
        t <- getCurrentTime
        tz <- getCurrentTimeZone
        return (utcToLocalTime tz t)
    insertNewSession conn t
    performGC
    insertNewSession conn t
    -- performGC
    threadDelay 1000000
