{-# LANGUAGE NumericUnderscores #-}
{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE TypeApplications #-}

import Data.Time
import qualified Data.Vector.Unboxed as VU
import qualified DataFrame as D
import qualified DataFrame.Functions as F
import System.Random.Stateful

import DataFrame ((|>))

main :: IO ()
main = do
    df <- D.readCsv "../db-benchmark/data/G1_2e6_1e2_0_0.csv"
    print df
    start <- getCurrentTime
    print $
        df
            |> D.groupBy ["id1"]
            |> D.aggregate [F.sum (F.col @Int "v1") `F.as` "v1_sum"]
    end <- getCurrentTime
    let computeTime = diffUTCTime end start
    putStrLn $ "Compute Time: " ++ show computeTime
