{-# LANGUAGE
  DeriveGeneric,
  DataKinds,
  DerivingVia,
  KindSignatures,
  TypeOperators #-}
module Main (main) where

import DerivingViaFun
import Data.Monoid (Sum(..), Any(..))
import GHC.Generics (Generic)

data T0 = T0 Int Bool
  deriving Generic
  deriving (Eq, Ord) via Fun (T0 ?-> (Int, Bool))
  deriving (Semigroup, Monoid) via Fun (GenericIso :: T0 ~> (Sum Int, Any)) -- test type annotations in deriving via

newtype All = All Bool
  deriving (Eq, Ord) via Fun (Coerce All Bool)
  deriving (Semigroup, Monoid) via Fun (Coerce All Bool >>> Not >>> Coerce Bool Any)

main :: IO ()
main = pure ()
