{-# LANGUAGE
  DeriveGeneric,
  DataKinds,
  DerivingVia,
  KindSignatures,
  TypeOperators #-}
module Main (main) where

import DerivingViaFun
import Data.Monoid (Sum(..), Any(..))
import Data.Functor.Product (Product(..))
import Data.Functor.Identity (Identity(..))
import GHC.Generics (Generic)

data T0 = T0 Int Bool
  deriving Generic
  deriving (Eq, Ord) via Fun (T0 ?-> (Int, Bool))
  deriving (Semigroup, Monoid) via Fun (GenericIso :: T0 ~> (Sum Int, Any)) -- test type annotations in deriving via

newtype All = All Bool
  deriving (Eq, Ord) via Fun (Coerce All Bool)
  deriving (Semigroup, Monoid) via Fun (Coerce All Bool >>> Not >>> Coerce Bool Any)

data T1 a = T1 [a] a
  deriving Generic
  deriving (Functor, Applicative, Monad, Foldable) via Fun1 (T1 ?-> Product [] Identity)

main :: IO ()
main = pure ()
