{-# LANGUAGE DeriveGeneric #-}
{-# LANGUAGE DeriveAnyClass #-}
{-# LANGUAGE OverloadedStrings #-}

module Fqn

where

-- project imports
import qualified Token

-- general imports
import Data.Aeson
import GHC.Generics

-- |
--
-- * Fully qualified name
-- * Resolution at the /file/ level
-- * Unidirectional resolution only ( one pass )
--
data Fqn
   = Imported ImportedContent
   | ClassInstance ClassInstanceContent
   | ClassName ClassNameContent
   | FieldedAccess Fqn Token.FieldName
   | NativeTypeInt
   | NativeTypeString
   | NativeTypeBool
   | NativeTypeConstInt Int
   | NativeTypeConstStr String
   | NativeTypeConstBool Bool
   | NativeTypeNull
   | Unknwon
   deriving ( Show, Eq, Ord, Generic, ToJSON, FromJSON )

data ImportedContent
   = ImportedLocal ImportedLocalContent
   | ImportedThirdParty ImportedThirdPartyContent
   deriving ( Show, Eq, Ord, Generic, ToJSON, FromJSON )

data ImportedLocalContent
   = ImportedLocalContent
     {
         importedLocalLocation :: FilePath,
         importedLocalRest :: [ String ]
     }
     deriving ( Show, Eq, Ord, Generic, ToJSON, FromJSON )

data ImportedThirdPartyContent
   = ImportedThirdPartyContent
     {
         importedThirdPartyName :: String,
         importedThirdPartyRest :: [ String ]
     }
     deriving ( Show, Eq, Ord, Generic, ToJSON, FromJSON )

data ClassInstanceContent
   = ClassInstanceContent
     {
         instanceName :: InstanceName,
         instanceOfClass :: Token.ClassName
     }
     deriving ( Show, Eq, Ord, Generic, ToJSON, FromJSON )

data InstanceName
   = Self -- ^ Python, Ruby
   | This -- ^ Java, Php, Javascript, Typescript
   deriving ( Show, Eq, Ord, Generic, ToJSON, FromJSON )

data InstanceAttribute
   = InstanceAttribute
     {
         attributeName :: Token.FieldName
     }
     deriving ( Show, Eq, Ord, Generic, ToJSON, FromJSON )

data ClassNameContent
   = ClassNameContent
     {
         classNameContent :: Token.ClassName
     }
     deriving ( Show, Eq, Ord, Generic, ToJSON, FromJSON )