# ecstatic

This package provides a way to build "as static as possible" Haskell
Linux executable.

## Why?

On Linux, using `-static` gcc flag will link all libraries statically,
including libc, which is explicitly [not
supported](https://sourceware.org/glibc/wiki/FAQ#Even_statically_linked_programs_need_some_shared_libraries_which_is_not_acceptable_for_me.__What_can_I_do.3F).
The correct way to build redistributable Linux executables is to statically link
everything except for libc (and link against an older glibc version, for
maximum compatibility), but ghc doesn't make it easy. **ecstatic** is a
drop-in replacement for the linker that will do the correct thing.

## Usage

Add this to the executable section of your cabal file:

```
    build-tool-depends: ecstatic:ecstatic >= 0.1.0
    ghc-options: -pgml ecstatic
```

You likely want to link dynamically by default; add a configuration flag:

```
Flag distrib
  description: Build redistributable executable
  default: False
  manual: True

...

executable your-awesome-program
  if flag(distrib) {
    build-tool-depends: ecstatic:ecstatic >= 0.1.0
    ghc-options: -pgml ecstatic
  }
```
